/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.utils.search;

import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import jadx.gui.utils.search.SearchIndex;
import jadx.gui.utils.search.StringRef;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class SimpleIndex<T>
implements SearchIndex<T> {
    private final List<String> keys = new ArrayList<String>();
    private final List<T> values = new ArrayList<T>();
    private final Object syncData = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(String str, T value) {
        Object object = this.syncData;
        synchronized (object) {
            this.keys.add(str);
            this.values.add(value);
        }
    }

    @Override
    public void put(StringRef str, T value) {
        throw new UnsupportedOperationException("StringRef not supported");
    }

    @Override
    public boolean isStringRefSupported() {
        return false;
    }

    private boolean isMatched(String str, String searchStr, boolean caseInsensitive) {
        if (caseInsensitive) {
            return StringUtils.containsIgnoreCase((CharSequence)str, (CharSequence)searchStr);
        }
        return str.contains(searchStr);
    }

    @Override
    public Flowable<T> search(String searchStr, boolean caseInsensitive) {
        return Flowable.create(emitter -> {
            Object object = this.syncData;
            synchronized (object) {
                int size = this.keys.size();
                for (int i = 0; i < size; ++i) {
                    if (this.isMatched(this.keys.get(i), searchStr, caseInsensitive)) {
                        emitter.onNext(this.values.get(i));
                    }
                    if (!emitter.isCancelled()) continue;
                    return;
                }
            }
            emitter.onComplete();
        }, (BackpressureStrategy)BackpressureStrategy.LATEST);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Object object = this.syncData;
        synchronized (object) {
            return this.keys.size();
        }
    }
}

