/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot;

import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.AddressException;
import sun.jvm.hotspot.debugger.DebuggerException;
import sun.jvm.hotspot.debugger.proc.ProcDebuggerLocal;

public class TestDebugger {
    private static void usage() {
        System.out.println("usage: java TestDebugger [pid]");
        System.out.println("pid must be the process ID of the helloWorld process");
        System.exit(1);
    }

    public static void main(String[] args) {
        try {
            if (args.length != 1) {
                TestDebugger.usage();
            }
            int pid = 0;
            try {
                pid = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException e) {
                TestDebugger.usage();
            }
            ProcDebuggerLocal debugger = new ProcDebuggerLocal(null, true);
            try {
                debugger.attach(pid);
            }
            catch (DebuggerException e) {
                System.err.print("Error attaching to process ID " + pid + ": ");
                if (e.getMessage() != null) {
                    System.err.print(e.getMessage());
                }
                System.err.println();
                System.exit(1);
            }
            debugger.configureJavaPrimitiveTypeSizes(1L, 1L, 2L, 8L, 4L, 4L, 8L, 2L);
            String loadObjectName = "-";
            Address addr = debugger.lookup(loadObjectName, "helloWorldString");
            if (addr == null) {
                System.err.println("Error looking up symbol \"helloWorldString\" in context \"" + loadObjectName + "\"");
                System.exit(1);
            }
            addr = addr.getAddressAt(0L);
            int helloWorldLen = 13;
            byte[] data = new byte[helloWorldLen];
            for (int i = 0; i < helloWorldLen; ++i) {
                data[i] = (byte)addr.getCIntegerAt(i, 1L, false);
            }
            char[] chars = new char[data.length];
            for (int i = 0; i < data.length; ++i) {
                chars[i] = (char)data[i];
            }
            String helloWorldStr = new String(chars);
            System.out.println("Successfully read string \"" + helloWorldStr + "\" from target process\n");
            byte expectedByteValue = -124;
            short expectedShortValue = 27890;
            int expectedIntValue = 1020304050;
            long expectedLongValue = 102030405060708090L;
            float expectedFloatValue = 35.4f;
            double expectedDoubleValue = 1.23456789;
            byte byteValue = 0;
            short shortValue = 0;
            int intValue = 0;
            long longValue = 0L;
            float floatValue = 0.0f;
            double doubleValue = 0.0;
            addr = debugger.lookup(loadObjectName, "testByte");
            if (addr == null) {
                System.err.println("Error looking up symbol \"testByte\" in context \"" + loadObjectName + "\"");
                System.exit(1);
            }
            if ((byteValue = addr.getJByteAt(0L)) != expectedByteValue) {
                System.err.println("Error: unexpected byte value (got " + byteValue + ", expected " + expectedByteValue + ")");
                System.exit(1);
            }
            if ((addr = debugger.lookup(loadObjectName, "testShort")) == null) {
                System.err.println("Error looking up symbol \"testShort\" in context \"" + loadObjectName + "\"");
                System.exit(1);
            }
            if ((shortValue = addr.getJShortAt(0L)) != expectedShortValue) {
                System.err.println("Error: unexpected short value (got " + shortValue + ", expected " + expectedShortValue + ")");
                System.exit(1);
            }
            if ((addr = debugger.lookup(loadObjectName, "testInt")) == null) {
                System.err.println("Error looking up symbol \"testInt\" in context \"" + loadObjectName + "\"");
                System.exit(1);
            }
            if ((intValue = addr.getJIntAt(0L)) != expectedIntValue) {
                System.err.println("Error: unexpected int value (got " + intValue + ", expected " + expectedIntValue + ")");
                System.exit(1);
            }
            if ((addr = debugger.lookup(loadObjectName, "testLong")) == null) {
                System.err.println("Error looking up symbol \"testLong\" in context \"" + loadObjectName + "\"");
                System.exit(1);
            }
            if ((longValue = addr.getJLongAt(0L)) != expectedLongValue) {
                System.err.println("Error: unexpected long value (got " + longValue + ", expected " + expectedLongValue + ")");
                System.exit(1);
            }
            if ((addr = debugger.lookup(loadObjectName, "testFloat")) == null) {
                System.err.println("Error looking up symbol \"testFloat\" in context \"" + loadObjectName + "\"");
                System.exit(1);
            }
            if ((floatValue = addr.getJFloatAt(0L)) != expectedFloatValue) {
                System.err.println("Error: unexpected float value (got " + floatValue + ", expected " + expectedFloatValue + ")");
                System.exit(1);
            }
            if ((addr = debugger.lookup(loadObjectName, "testDouble")) == null) {
                System.err.println("Error looking up symbol \"testDouble\" in context \"" + loadObjectName + "\"");
                System.exit(1);
            }
            if ((doubleValue = addr.getJDoubleAt(0L)) != expectedDoubleValue) {
                System.err.println("Error: unexpected double value (got " + doubleValue + ", expected " + expectedDoubleValue + ")");
                System.exit(1);
            }
            System.err.println("All tests passed successfully.");
            debugger.detach();
        }
        catch (AddressException e) {
            System.err.println("Error occurred during test:");
            e.printStackTrace();
            System.exit(1);
        }
    }
}

