/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.debugger;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPanel;
import javax.swing.text.BadLocationException;
import org.mozilla.javascript.tools.debugger.FileTextArea;
import org.mozilla.javascript.tools.debugger.FileWindow;

class FileHeader
extends JPanel
implements MouseListener {
    private static final long serialVersionUID = -2858905404778259127L;
    private int pressLine = -1;
    private FileWindow fileWindow;

    public FileHeader(FileWindow fileWindow) {
        this.fileWindow = fileWindow;
        this.addMouseListener(this);
        this.update();
    }

    public void update() {
        FileTextArea fileTextArea = this.fileWindow.textArea;
        Font font = fileTextArea.getFont();
        this.setFont(font);
        FontMetrics fontMetrics = this.getFontMetrics(font);
        int n = fontMetrics.getHeight();
        int n2 = fileTextArea.getLineCount() + 1;
        String string = Integer.toString(n2);
        if (string.length() < 2) {
            string = "99";
        }
        Dimension dimension = new Dimension();
        dimension.width = fontMetrics.stringWidth(string) + 16;
        dimension.height = n2 * n + 100;
        this.setPreferredSize(dimension);
        this.setSize(dimension);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        FileTextArea fileTextArea = this.fileWindow.textArea;
        Font font = fileTextArea.getFont();
        graphics.setFont(font);
        FontMetrics fontMetrics = this.getFontMetrics(font);
        Rectangle rectangle = graphics.getClipBounds();
        graphics.setColor(this.getBackground());
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        int n = fontMetrics.getMaxAscent();
        int n2 = fontMetrics.getHeight();
        int n3 = fileTextArea.getLineCount() + 1;
        String string = Integer.toString(n3);
        if (string.length() < 2) {
            string = "99";
        }
        int n4 = rectangle.y / n2;
        int n5 = (rectangle.y + rectangle.height) / n2 + 1;
        int n6 = this.getWidth();
        if (n5 > n3) {
            n5 = n3;
        }
        for (int i = n4; i < n5; ++i) {
            int n7 = -2;
            try {
                n7 = fileTextArea.getLineStartOffset(i);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            boolean bl = this.fileWindow.isBreakPoint(i + 1);
            String string2 = Integer.toString(i + 1) + " ";
            int n8 = i * n2;
            graphics.setColor(Color.blue);
            graphics.drawString(string2, 0, n8 + n);
            int n9 = n6 - n;
            if (bl) {
                graphics.setColor(new Color(128, 0, 0));
                int n10 = n8 + n - 9;
                graphics.fillOval(n9, n10, 9, 9);
                graphics.drawOval(n9, n10, 8, 8);
                graphics.drawOval(n9, n10, 9, 9);
            }
            if (n7 != this.fileWindow.currentPos) continue;
            Polygon polygon = new Polygon();
            int n11 = n9;
            int n12 = n8 += n - 10;
            polygon.addPoint(n11, n12 + 3);
            polygon.addPoint(n11 + 5, n12 + 3);
            n9 = n11 + 5;
            while (n9 <= n11 + 10) {
                polygon.addPoint(n9, n8);
                ++n9;
                ++n8;
            }
            n9 = n11 + 9;
            while (n9 >= n11 + 5) {
                polygon.addPoint(n9, n8);
                --n9;
                ++n8;
            }
            polygon.addPoint(n11 + 5, n12 + 7);
            polygon.addPoint(n11, n12 + 7);
            graphics.setColor(Color.yellow);
            graphics.fillPolygon(polygon);
            graphics.setColor(Color.black);
            graphics.drawPolygon(polygon);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Font font = this.fileWindow.textArea.getFont();
        FontMetrics fontMetrics = this.getFontMetrics(font);
        int n = fontMetrics.getHeight();
        this.pressLine = mouseEvent.getY() / n;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getComponent() == this && (mouseEvent.getModifiers() & 0x10) != 0) {
            Font font;
            FontMetrics fontMetrics;
            int n;
            int n2 = mouseEvent.getY();
            int n3 = n2 / (n = (fontMetrics = this.getFontMetrics(font = this.fileWindow.textArea.getFont())).getHeight());
            if (n3 == this.pressLine) {
                this.fileWindow.toggleBreakPoint(n3 + 1);
            } else {
                this.pressLine = -1;
            }
        }
    }
}

