/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.exec;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public abstract class LogOutputStream
extends OutputStream {
    private static final int INTIAL_SIZE = 132;
    private static final int CR = 13;
    private static final int LF = 10;
    private final ByteArrayOutputStream buffer = new ByteArrayOutputStream(132);
    private boolean skip = false;
    private final int level;

    public LogOutputStream() {
        this(999);
    }

    public LogOutputStream(int n) {
        this.level = n;
    }

    @Override
    public void write(int n) throws IOException {
        byte by = (byte)n;
        if (by == 10 || by == 13) {
            if (!this.skip) {
                this.processBuffer();
            }
        } else {
            this.buffer.write(n);
        }
        this.skip = by == 13;
    }

    @Override
    public void flush() {
        if (this.buffer.size() > 0) {
            this.processBuffer();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.buffer.size() > 0) {
            this.processBuffer();
        }
        super.close();
    }

    public int getMessageLevel() {
        return this.level;
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4 = n3 = n;
        int n5 = n2;
        while (n5 > 0) {
            while (n5 > 0 && byArray[n3] != 10 && byArray[n3] != 13) {
                ++n3;
                --n5;
            }
            int n6 = n3 - n4;
            if (n6 > 0) {
                this.buffer.write(byArray, n4, n6);
            }
            while (n5 > 0 && (byArray[n3] == 10 || byArray[n3] == 13)) {
                this.write(byArray[n3]);
                ++n3;
                --n5;
            }
            n4 = n3;
        }
    }

    protected void processBuffer() {
        this.processLine(this.buffer.toString());
        this.buffer.reset();
    }

    protected void processLine(String string) {
        this.processLine(string, this.level);
    }

    protected abstract void processLine(String var1, int var2);
}

