/* SPDX-License-Identifier: GPL-2.0+ */
/*
 * Copyright (c) 2024 9elements GmbH
 */

#ifndef __CONFIG_H
#define __CONFIG_H

/* Physical memory map */

/* SECURE_FLASH */
#define SBSA_SECURE_FLASH_BASE_ADDR	0x00000000
#define SBSA_SECURE_FLASH_LENGTH	0x10000000

/* FLASH */
#define SBSA_FLASH_BASE_ADDR		0x10000000
#define SBSA_FLASH_LENGTH		0x10000000

/* PERIPH */
#define SBSA_PERIPH_BASE_ADDR		0x40000000

/* GIC_DIST */
#define SBSA_GIC_DIST_BASE_ADDR		0x40060000
#define SBSA_GIC_DIST_LENGTH		0x00020000

#define SBSA_GIC_VBASE_ADDR		0x2c020000
#define SBSA_GIC_VBASE_LENGTH		0x00010000

#define SBSA_GIC_HBASE_ADDR		0x2c010000
#define SBSA_GIC_HBASE_LENGTH		0x00010000

/* GIC_REDIST */
#define SBSA_GIC_REDIST_BASE_ADDR	0x40080000
#define SBSA_GIC_REDIST_LENGTH		0x04000000

/* GIC_ITS */
#define SBSA_GIC_ITS_BASE_ADDR		0x44081000

/* UART */
#define SBSA_UART_BASE_ADDR		0x60000000
#define SBSA_UART_LENGTH		0x00001000

/* SMMU */
#define SBSA_SMMU_BASE_ADDR		0x60050000

/* SATA */
#define SBSA_AHCI_BASE_ADDR		0x60100000
#define SBSA_AHCI_LENGTH		0x00010000

/* xHCI */
#define SBSA_XHCI_BASE_ADDR		0x60110000
#define SBSA_XHCI_LENGTH		0x00010000

/* PIO */
#define SBSA_PIO_BASE_ADDR		0x7fff0000
#define SBSA_PIO_LENGTH			0x00010000

/* PCIE_MMIO */
#define SBSA_PCIE_MMIO_BASE_ADDR	0x80000000
#define SBSA_PCIE_MMIO_LENGTH		0x70000000
#define SBSA_PCIE_MMIO_END		0xefffffff

/* PCIE_ECAM */
#define SBSA_PCIE_ECAM_BASE_ADDR	0xf0000000
#define SBSA_PCIE_ECAM_LENGTH		0x10000000
#define SBSA_PCIE_ECAM_END		0xffffffff

/* PCIE_MMIO_HIGH */
#ifdef __ACPI__
#define SBSA_PCIE_MMIO_HIGH_BASE_ADDR	0x100000000
#define SBSA_PCIE_MMIO_HIGH_LENGTH	0xFF00000000
#define SBSA_PCIE_MMIO_HIGH_END		0xFFFFFFFFFF
#else
#define SBSA_PCIE_MMIO_HIGH_BASE_ADDR	0x100000000ULL
#define SBSA_PCIE_MMIO_HIGH_LENGTH	0xFF00000000ULL
#define SBSA_PCIE_MMIO_HIGH_END		0xFFFFFFFFFFULL
#endif

/* MEM */
#ifdef __ACPI__
#define SBSA_MEM_BASE_ADDR		0x10000000000
#else
#define SBSA_MEM_BASE_ADDR		0x10000000000ULL
#endif

#define CFG_SYS_INIT_RAM_ADDR		SBSA_MEM_BASE_ADDR
#define CFG_SYS_INIT_RAM_SIZE		0x1000000

/* Generic Interrupt Controller Definitions */
#define GICD_BASE			SBSA_GIC_DIST_BASE_ADDR
#define GICR_BASE			SBSA_GIC_REDIST_BASE_ADDR

#endif /* __CONFIG_H */
