/* SPDX-License-Identifier: GPL-2.0 */
/*
 * Copyright (c) 2020 Rockchip Electronics Co. Ltd.
 * Author: Elaine Zhang <zhangqing@rock-chips.com>
 */

#ifndef _ASM_ARCH_CRU_RK3576_H
#define _ASM_ARCH_CRU_RK3576_H

#define MHz		1000000
#define KHz		1000
#define OSC_HZ		(24 * MHz)

#define CPU_PVTPLL_HZ	(1008 * MHz)
#define LPLL_HZ		(816 * MHz)
#define GPLL_HZ		(1188 * MHz)
#define CPLL_HZ		(1000 * MHz)
#define PPLL_HZ		(1100 * MHz)
#define GMAC0_PTP_REFCLK_IN	(24 * MHz)
#define GMAC1_PTP_REFCLK_IN	(24 * MHz)

/* RK3576 pll id */
enum rk3576_pll_id {
	BPLL,
	LPLL,
	DPLL,
	CPLL,
	GPLL,
	VPLL,
	AUPLL,
	SPLL,
	PPLL,
	PLL_COUNT,
};

struct rk3576_clk_priv {
	struct rk3576_cru *cru;
	ulong ppll_hz;
	ulong gpll_hz;
	ulong cpll_hz;
	ulong vpll_hz;
	ulong aupll_hz;
	ulong spll_hz;
	ulong lpll_hz;
	ulong bpll_hz;
	ulong armclk_hz;
	ulong armclk_enter_hz;
	ulong armclk_init_hz;
	bool sync_kernel;
	bool set_armclk_rate;
};

struct rk3576_pll {
	unsigned int con0;
	unsigned int con1;
	unsigned int con2;
	unsigned int con3;
	unsigned int con4;
	unsigned int reserved0[3];
};

struct rk3576_cru {
	struct rk3576_pll pll[18];
	unsigned int reserved0[16];/* Address Offset: 0x0240 */
	unsigned int mode_con00;/* Address Offset: 0x0280 */
	unsigned int reserved1[31];/* Address Offset: 0x0284 */
	unsigned int clksel_con[181]; /* Address Offset: 0x0300 */
	unsigned int reserved2[139];/* Address Offset: 0x05d4 */
	unsigned int clkgate_con[80];/* Address Offset: 0x0800 */
	unsigned int reserved3[48];/* Address Offset: 0x0938 */
	unsigned int softrst_con[80];/* Address Offset: 0x0400 */
	unsigned int reserved4[48];/* Address Offset: 0x0b38 */
	unsigned int glb_cnt_th;/* Address Offset: 0x0c00 */
	unsigned int glb_rst_st;/* Address Offset: 0x0c04 */
	unsigned int glb_srst_fst;/* Address Offset: 0x0c08 */
	unsigned int glb_srsr_snd; /* Address Offset: 0x0c0c */
	unsigned int glb_rst_con;/* Address Offset: 0x0c10 */
	unsigned int reserved5[43];/* Address Offset: 0x0c14 */
	unsigned int smoth_divfree_con[3];/* Address Offset: 0x0cc0 */
	unsigned int fracdiv_high_con[4];/* Address Offset: 0x0ccc */
	unsigned int reserved8[32137];/* Address Offset: 0x0c38 */
	unsigned int pmuclksel_con[22]; /* Address Offset: 0x20300 */
	unsigned int reserved9[298];/* Address Offset: 0x20358 */
	unsigned int pmuclkgate_con[8]; /* Address Offset: 0x20800 */
	unsigned int reserved10[32440];/* Address Offset: 0x20820 */
	unsigned int litclksel_con[4]; /* Address Offset: 0x40300 */
};

check_member(rk3576_cru, mode_con00, 0x280);
check_member(rk3576_cru, pmuclksel_con[1], 0x20304);

struct pll_rate_table {
	unsigned long rate;
	unsigned int m;
	unsigned int p;
	unsigned int s;
	unsigned int k;
};

#define RK3576_PHP_CRU_BASE		0x8000
#define RK3576_PMU_CRU_BASE		0x20000
#define RK3576_BIGCORE_CRU_BASE		0x38000
#define RK3576_LITCORE_CRU_BASE		0x40000
#define RK3576_CCI_CRU_BASE		0x48000
#define RK3576_CRU_BASE			0x27200000
#define RK3576_SCRU_BASE		0x27214000

#define RK3576_BIGCORE_GRF_BASE		0x2600C000
#define RK3576_LITCORE_GRF_BASE		0x2600E000
#define RK3576_CCI_GRF_BASE		0x26010000

#define RK3576_PLL_CON(x)		((x) * 0x4)
#define RK3576_MODE_CON0		0x280
#define RK3576_BPLL_MODE_CON0		(RK3576_BIGCORE_CRU_BASE + 0x280)
#define RK3576_LPLL_MODE_CON0		(RK3576_LITCORE_CRU_BASE + 0x280)
#define RK3576_PPLL_MODE_CON0		(RK3576_PHP_CRU_BASE + 0x280)
#define RK3576_CLKSEL_CON(x)		((x) * 0x4 + 0x300)
#define RK3576_CLKGATE_CON(x)		((x) * 0x4 + 0x800)
#define RK3576_SOFTRST_CON(x)		((x) * 0x4 + 0xa00)
#define RK3576_GLB_CNT_TH		0xc00
#define RK3576_GLB_SRST_FST		0xc08
#define RK3576_GLB_SRST_SND		0xc0c
#define RK3576_GLB_RST_CON		0xc10
#define RK3576_GLB_RST_ST		0xc04
#define RK3576_SDIO_CON0		0xC24
#define RK3576_SDIO_CON1		0xC28
#define RK3576_SDMMC_CON0		0xC30
#define RK3576_SDMMC_CON1		0xC34

#define RK3576_PHP_CLKSEL_CON(x)	((x) * 0x4 + RK3576_PHP_CRU_BASE + 0x300)
#define RK3576_PHP_CLKGATE_CON(x)	((x) * 0x4 + RK3576_PHP_CRU_BASE + 0x800)
#define RK3576_PHP_SOFTRST_CON(x)	((x) * 0x4 + RK3576_PHP_CRU_BASE + 0xa00)

#define RK3576_PMU_PLL_CON(x)		((x) * 0x4 + RK3576_PHP_CRU_BASE)
#define RK3576_PMU_CLKSEL_CON(x)	((x) * 0x4 + RK3576_PMU_CRU_BASE + 0x300)
#define RK3576_PMU_CLKGATE_CON(x)	((x) * 0x4 + RK3576_PMU_CRU_BASE + 0x800)
#define RK3576_PMU_SOFTRST_CON(x)	((x) * 0x4 + RK3576_PMU_CRU_BASE + 0xa00)

#define RK3576_CCI_CLKSEL_CON(x)	((x) * 0x4 + RK3576_CCI_CRU_BASE + 0x300)
#define RK3576_CCI_CLKGATE_CON(x)	((x) * 0x4 + RK3576_CCI_CRU_BASE + 0x800)
#define RK3576_CCI_SOFTRST_CON(x)	((x) * 0x4 + RK3576_CCI_CRU_BASE + 0xa00)

#define RK3576_BPLL_CON(x)		((x) * 0x4 + RK3576_BIGCORE_CRU_BASE)
#define RK3576_BIGCORE_CLKSEL_CON(x)	((x) * 0x4 + RK3576_BIGCORE_CRU_BASE + 0x300)
#define RK3576_BIGCORE_CLKGATE_CON(x)	((x) * 0x4 + RK3576_BIGCORE_CRU_BASE + 0x800)
#define RK3576_BIGCORE_SOFTRST_CON(x)	((x) * 0x4 + RK3576_BIGCORE_CRU_BASE + 0xa00)
#define RK3576_LPLL_CON(x)		((x) * 0x4 + RK3576_CCI_CRU_BASE)
#define RK3576_LITCORE_CLKSEL_CON(x)	((x) * 0x4 + RK3576_LITCORE_CRU_BASE + 0x300)
#define RK3576_LITCORE_CLKGATE_CON(x)	((x) * 0x4 + RK3576_LITCORE_CRU_BASE + 0x800)
#define RK3576_LITCORE_SOFTRST_CON(x)	((x) * 0x4 + RK3576_LITCORE_CRU_BASE + 0xa00)

enum {
	/* CRU_CLK_SEL8_CON */
	PCLK_TOP_SEL_SHIFT		= 7,
	PCLK_TOP_SEL_MASK		= 3 << PCLK_TOP_SEL_SHIFT,
	PCLK_TOP_SEL_100M		= 0,
	PCLK_TOP_SEL_50M,
	PCLK_TOP_SEL_OSC,

	/* CRU_CLK_SEL9_CON */
	ACLK_TOP_SEL_SHIFT		= 5,
	ACLK_TOP_SEL_MASK		= 3 << ACLK_TOP_SEL_SHIFT,
	ACLK_TOP_SEL_GPLL		= 0,
	ACLK_TOP_SEL_CPLL,
	ACLK_TOP_SEL_AUPLL,
	ACLK_TOP_DIV_SHIFT		= 0,
	ACLK_TOP_DIV_MASK		= 0x1f << ACLK_TOP_DIV_SHIFT,

	/* CRU_CLK_SEL10_CON */
	ACLK_TOP_MID_SEL_SHIFT		= 5,
	ACLK_TOP_MID_SEL_MASK		= 1 << ACLK_TOP_MID_SEL_SHIFT,
	ACLK_TOP_MID_SEL_GPLL		= 0,
	ACLK_TOP_MID_SEL_CPLL,
	ACLK_TOP_MID_DIV_SHIFT		= 0,
	ACLK_TOP_MID_DIV_MASK		= 0x1f << ACLK_TOP_MID_DIV_SHIFT,

	/* CRU_CLK_SEL19_CON */
	HCLK_TOP_SEL_SHIFT		= 2,
	HCLK_TOP_SEL_MASK		= 3 << HCLK_TOP_SEL_SHIFT,
	HCLK_TOP_SEL_200M		= 0,
	HCLK_TOP_SEL_100M,
	HCLK_TOP_SEL_50M,
	HCLK_TOP_SEL_OSC,

	/* CRU_CLK_SEL25_CON */
	CLK_UART_FRAC_NUMERATOR_SHIFT	= 16,
	CLK_UART_FRAC_NUMERATOR_MASK	= 0xffff << 16,
	CLK_UART_FRAC_DENOMINATOR_SHIFT	= 0,
	CLK_UART_FRAC_DENOMINATOR_MASK	= 0xffff,

	/* CRU_CLK_SEL26_CON */
	CLK_UART_SRC_SEL_SHIFT		= 0,
	CLK_UART_SRC_SEL_MASK		= 0x3 << CLK_UART_SRC_SEL_SHIFT,
	CLK_UART_SRC_SEL_GPLL		= 0,
	CLK_UART_SRC_SEL_CPLL,
	CLK_UART_SRC_SEL_AUPLL,
	CLK_UART_SRC_SEL_OSC,

	/* CRU_CLK_SEL27_CON */
	CLK_UART1_SRC_SEL_SHIFT		= 13,
	CLK_UART1_SRC_SEL_MASK		= 0x7 << CLK_UART1_SRC_SEL_SHIFT,
	CLK_UART1_SRC_DIV_SHIFT		= 5,
	CLK_UART1_SRC_DIV_MASK		= 0xff << CLK_UART1_SRC_DIV_SHIFT,

	/* CRU_CLK_SEL30_CON */
	CLK_GMAC0_125M_DIV_SHIFT	= 10,
	CLK_GMAC0_125M_DIV_MASK		= 0x1f << CLK_GMAC0_125M_DIV_SHIFT,

	/* CRU_CLK_SEL31_CON */
	CLK_GMAC1_125M_DIV_SHIFT	= 0,
	CLK_GMAC1_125M_DIV_MASK		= 0x1f << CLK_GMAC1_125M_DIV_SHIFT,

	/* CRU_CLK_SEL33_CON */
	REF_CLK0_OUT_PLL_SEL_SHIFT	= 8,
	REF_CLK0_OUT_PLL_SEL_MASK	= 7 << REF_CLK0_OUT_PLL_SEL_SHIFT,
	REF_CLK0_OUT_PLL_SEL_GPLL	= 0,
	REF_CLK0_OUT_PLL_SEL_CPLL,
	REF_CLK0_OUT_PLL_SEL_SPLL,
	REF_CLK0_OUT_PLL_SEL_AUPLL,
	REF_CLK0_OUT_PLL_SEL_LPLL,
	REF_CLK0_OUT_PLL_SEL_OSC,
	REF_CLK0_OUT_PLL_DIV_SHIFT	= 0,
	REF_CLK0_OUT_PLL_DIV_MASK	= 0xff << REF_CLK0_OUT_PLL_DIV_SHIFT,

	/* CRU_CLK_SEL55_CON */
	ACLK_BUS_ROOT_SEL_SHIFT		= 9,
	ACLK_BUS_ROOT_SEL_MASK		= 1 << ACLK_BUS_ROOT_SEL_SHIFT,
	ACLK_BUS_ROOT_SEL_GPLL		= 0,
	ACLK_BUS_ROOT_SEL_CPLL,
	ACLK_BUS_ROOT_DIV_SHIFT		= 4,
	ACLK_BUS_ROOT_DIV_MASK		= 0x1f << ACLK_BUS_ROOT_DIV_SHIFT,
	PCLK_BUS_ROOT_SEL_SHIFT		= 2,
	PCLK_BUS_ROOT_SEL_MASK		= 3 << PCLK_BUS_ROOT_SEL_SHIFT,
	PCLK_BUS_ROOT_SEL_100M		= 0,
	PCLK_BUS_ROOT_SEL_50M,
	PCLK_BUS_ROOT_SEL_OSC,
	HCLK_BUS_ROOT_SEL_SHIFT		= 0,
	HCLK_BUS_ROOT_SEL_MASK		= 3 << HCLK_BUS_ROOT_SEL_SHIFT,
	HCLK_BUS_ROOT_SEL_200M		= 0,
	HCLK_BUS_ROOT_SEL_100M,
	HCLK_BUS_ROOT_SEL_50M,
	HCLK_BUS_ROOT_SEL_OSC,

	/* CRU_CLK_SEL57_CON */
	CLK_I2C8_SEL_SHIFT		= 14,
	CLK_I2C8_SEL_MASK		= 3 << CLK_I2C8_SEL_SHIFT,
	CLK_I2C7_SEL_SHIFT		= 12,
	CLK_I2C7_SEL_MASK		= 3 << CLK_I2C7_SEL_SHIFT,
	CLK_I2C6_SEL_SHIFT		= 10,
	CLK_I2C6_SEL_MASK		= 3 << CLK_I2C6_SEL_SHIFT,
	CLK_I2C5_SEL_SHIFT		= 8,
	CLK_I2C5_SEL_MASK		= 3 << CLK_I2C5_SEL_SHIFT,
	CLK_I2C4_SEL_SHIFT		= 6,
	CLK_I2C4_SEL_MASK		= 3 << CLK_I2C4_SEL_SHIFT,
	CLK_I2C3_SEL_SHIFT		= 4,
	CLK_I2C3_SEL_MASK		= 3 << CLK_I2C3_SEL_SHIFT,
	CLK_I2C2_SEL_SHIFT		= 2,
	CLK_I2C2_SEL_MASK		= 3 << CLK_I2C2_SEL_SHIFT,
	CLK_I2C1_SEL_SHIFT		= 0,
	CLK_I2C1_SEL_MASK		= 3 << CLK_I2C1_SEL_SHIFT,
	CLK_I2C_SEL_200M		= 0,
	CLK_I2C_SEL_100M,
	CLK_I2C_SEL_50M,
	CLK_I2C_SEL_OSC,

	/* CRU_CLK_SEL58_CON */
	CLK_SARADC_SEL_SHIFT		= 12,
	CLK_SARADC_SEL_MASK		= 0x1 << CLK_SARADC_SEL_SHIFT,
	CLK_SARADC_SEL_GPLL		= 0,
	CLK_SARADC_SEL_OSC,
	CLK_SARADC_DIV_SHIFT		= 4,
	CLK_SARADC_DIV_MASK		= 0xff << CLK_SARADC_DIV_SHIFT,
	CLK_I2C9_SEL_SHIFT		= 0,
	CLK_I2C9_SEL_MASK		= 3 << CLK_I2C9_SEL_SHIFT,

	/* CRU_CLK_SEL59_CON */
	CLK_TSADC_DIV_SHIFT		= 0,
	CLK_TSADC_DIV_MASK		= 0xff << CLK_TSADC_DIV_SHIFT,

	/* CRU_CLK_SEL60_CON */
	CLK_UART_SEL_SHIFT		= 8,
	CLK_UART_SEL_MASK		= 7 << CLK_UART_SEL_SHIFT,
	CLK_UART_SEL_GPLL		= 0,
	CLK_UART_SEL_CPLL,
	CLK_UART_SEL_AUPLL,
	CLK_UART_SEL_OSC,
	CLK_UART_SEL_FRAC0,
	CLK_UART_SEL_FRAC1,
	CLK_UART_SEL_FRAC2,
	CLK_UART_DIV_SHIFT		= 0,
	CLK_UART_DIV_MASK		= 0xff << CLK_UART_DIV_SHIFT,

	/* CRU_CLK_SEL70_CON */
	CLK_SPI0_SEL_SHIFT		= 13,
	CLK_SPI0_SEL_MASK		= 3 << CLK_SPI0_SEL_SHIFT,
	CLK_SPI_SEL_200M		= 0,
	CLK_SPI_SEL_100M,
	CLK_SPI_SEL_50M,
	CLK_SPI_SEL_OSC,

	/* CRU_CLK_SEL71_CON */
	CLK_PWM1_SEL_SHIFT		= 8,
	CLK_PWM1_SEL_MASK		= 3 << CLK_PWM1_SEL_SHIFT,
	CLK_SPI4_SEL_SHIFT		= 6,
	CLK_SPI4_SEL_MASK		= 3 << CLK_SPI4_SEL_SHIFT,
	CLK_SPI3_SEL_SHIFT		= 4,
	CLK_SPI3_SEL_MASK		= 3 << CLK_SPI3_SEL_SHIFT,
	CLK_SPI2_SEL_SHIFT		= 2,
	CLK_SPI2_SEL_MASK		= 3 << CLK_SPI2_SEL_SHIFT,
	CLK_SPI1_SEL_SHIFT		= 0,
	CLK_SPI1_SEL_MASK		= 3 << CLK_SPI1_SEL_SHIFT,
	CLK_PWM_SEL_100M		= 0,
	CLK_PWM_SEL_50M,
	CLK_PWM_SEL_OSC,

	/* CRU_CLK_SEL72_CON */
	DCLK_DECOM_SEL_SHIFT		= 5,
	DCLK_DECOM_SEL_MASK		= 1 << DCLK_DECOM_SEL_SHIFT,
	DCLK_DECOM_SEL_GPLL		= 0,
	DCLK_DECOM_SEL_SPLL,
	DCLK_DECOM_DIV_SHIFT		= 0,
	DCLK_DECOM_DIV_MASK		= 0x1f << DCLK_DECOM_DIV_SHIFT,

	/* CRU_CLK_SEL74_CON */
	CLK_PWM2_SEL_SHIFT		= 6,
	CLK_PWM2_SEL_MASK		= 3 << CLK_PWM2_SEL_SHIFT,

	/* CRU_CLK_SEL89_CON */
	CCLK_EMMC_SEL_SHIFT		= 14,
	CCLK_EMMC_SEL_MASK		= 3 << CCLK_EMMC_SEL_SHIFT,
	CCLK_EMMC_SEL_GPLL		= 0,
	CCLK_EMMC_SEL_CPLL,
	CCLK_EMMC_SEL_OSC,
	CCLK_EMMC_DIV_SHIFT		= 8,
	CCLK_EMMC_DIV_MASK		= 0x3f << CCLK_EMMC_DIV_SHIFT,
	SCLK_FSPI_SEL_SHIFT		= 6,
	SCLK_FSPI_SEL_MASK		= 3 << SCLK_FSPI_SEL_SHIFT,
	SCLK_FSPI_SEL_GPLL		= 0,
	SCLK_FSPI_SEL_CPLL,
	SCLK_FSPI_SEL_OSC,
	SCLK_FSPI_DIV_SHIFT		= 0,
	SCLK_FSPI_DIV_MASK		= 0x3f << SCLK_FSPI_DIV_SHIFT,

	/* CRU_CLK_SEL90_CON */
	BCLK_EMMC_SEL_SHIFT		= 0,
	BCLK_EMMC_SEL_MASK		= 3 << BCLK_EMMC_SEL_SHIFT,
	BCLK_EMMC_SEL_200M		= 0,
	BCLK_EMMC_SEL_100M,
	BCLK_EMMC_SEL_50M,
	BCLK_EMMC_SEL_OSC,

	/* CRU_CLK_SEL104_CON */
	CLK_GMAC1_PTP_SEL_SHIFT		= 13,
	CLK_GMAC1_PTP_SEL_MASK		= 3 << CLK_GMAC1_PTP_SEL_SHIFT,
	CLK_GMAC1_PTP_SEL_GPLL		= 0,
	CLK_GMAC1_PTP_SEL_CPLL,
	CLK_GMAC1_PTP_SEL_REFIN,
	CLK_GMAC1_PTP_DIV_SHIFT		= 8,
	CLK_GMAC1_PTP_DIV_MASK		= 0x1f << CLK_GMAC1_PTP_DIV_SHIFT,
	CCLK_SDIO_SRC_SEL_SHIFT		= 6,
	CCLK_SDIO_SRC_SEL_MASK		= 3 << CCLK_SDIO_SRC_SEL_SHIFT,
	CCLK_SDIO_SRC_SEL_GPLL		= 0,
	CCLK_SDIO_SRC_SEL_CPLL,
	CCLK_SDIO_SRC_SEL_OSC,
	CCLK_SDIO_SRC_DIV_SHIFT		= 0,
	CCLK_SDIO_SRC_DIV_MASK		= 0x3f << CCLK_SDIO_SRC_DIV_SHIFT,

	/* CRU_CLK_SEL105_CON */
	CCLK_SDMMC0_SRC_SEL_SHIFT	= 13,
	CCLK_SDMMC0_SRC_SEL_MASK	= 3 << CCLK_SDMMC0_SRC_SEL_SHIFT,
	CCLK_SDMMC0_SRC_SEL_GPLL	= 0,
	CCLK_SDMMC0_SRC_SEL_CPLL,
	CCLK_SDMMC0_SRC_SEL_OSC,
	CCLK_SDMMC0_SRC_DIV_SHIFT	= 7,
	CCLK_SDMMC0_SRC_DIV_MASK	= 0x3f << CCLK_SDMMC0_SRC_DIV_SHIFT,
	CLK_GMAC0_PTP_SEL_SHIFT		= 5,
	CLK_GMAC0_PTP_SEL_MASK		= 3 << CLK_GMAC0_PTP_SEL_SHIFT,
	CLK_GMAC0_PTP_SEL_GPLL		= 0,
	CLK_GMAC0_PTP_SEL_CPLL,
	CLK_GMAC0_PTP_SEL_REFIN,
	CLK_GMAC0_PTP_DIV_SHIFT		= 0,
	CLK_GMAC0_PTP_DIV_MASK		= 0x1f << CLK_GMAC0_PTP_DIV_SHIFT,

	/* CRU_CLK_SEL123_CON */
	DCLK_EBC_SEL_SHIFT		= 12,
	DCLK_EBC_SEL_MASK		= 7 << DCLK_EBC_SEL_SHIFT,
	DCLK_EBC_SEL_GPLL		= 0,
	DCLK_EBC_SEL_CPLL,
	DCLK_EBC_SEL_VPLL,
	DCLK_EBC_SEL_AUPLL,
	DCLK_EBC_SEL_LPLL,
	DCLK_EBC_SEL_FRAC_SRC,
	DCLK_EBC_SEL_OSC,
	DCLK_EBC_DIV_SHIFT		= 3,
	DCLK_EBC_DIV_MASK		= 0x1ff << DCLK_EBC_DIV_SHIFT,
	DCLK_EBC_FRAC_SRC_SEL_SHIFT	= 0,
	DCLK_EBC_FRAC_SRC_SEL_MASK	= 7 << DCLK_EBC_FRAC_SRC_SEL_SHIFT,
	DCLK_EBC_FRAC_SRC_SEL_GPLL	= 0,
	DCLK_EBC_FRAC_SRC_SEL_CPLL,
	DCLK_EBC_FRAC_SRC_SEL_VPLL,
	DCLK_EBC_FRAC_SRC_SEL_AUPLL,
	DCLK_EBC_FRAC_SRC_SEL_OSC,

	/* CRU_CLK_SEL144_CON */
	PCLK_VOP_ROOT_SEL_SHIFT		= 12,
	PCLK_VOP_ROOT_SEL_MASK		= 3 << PCLK_VOP_ROOT_SEL_SHIFT,
	PCLK_VOP_ROOT_SEL_100M		= 0,
	PCLK_VOP_ROOT_SEL_50M,
	PCLK_VOP_ROOT_SEL_OSC,
	HCLK_VOP_ROOT_SEL_SHIFT		= 10,
	HCLK_VOP_ROOT_SEL_MASK		= 3 << HCLK_VOP_ROOT_SEL_SHIFT,
	HCLK_VOP_ROOT_SEL_200M		= 0,
	HCLK_VOP_ROOT_SEL_100M,
	HCLK_VOP_ROOT_SEL_50M,
	HCLK_VOP_ROOT_SEL_OSC,
	ACLK_VOP_ROOT_SEL_SHIFT		= 5,
	ACLK_VOP_ROOT_SEL_MASK		= 7 << ACLK_VOP_ROOT_SEL_SHIFT,
	ACLK_VOP_ROOT_SEL_GPLL		= 0,
	ACLK_VOP_ROOT_SEL_CPLL,
	ACLK_VOP_ROOT_SEL_AUPLL,
	ACLK_VOP_ROOT_SEL_SPLL,
	ACLK_VOP_ROOT_SEL_LPLL,
	ACLK_VOP_ROOT_DIV_SHIFT		= 0,
	ACLK_VOP_ROOT_DIV_MASK		= 0x1f << ACLK_VOP_ROOT_DIV_SHIFT,

	/* CRU_CLK_SEL145_CON */
	DCLK0_VOP_SRC_SEL_SHIFT		= 8,
	DCLK0_VOP_SRC_SEL_MASK		= 7 << DCLK0_VOP_SRC_SEL_SHIFT,
	DCLK_VOP_SRC_SEL_GPLL		= 0,
	DCLK_VOP_SRC_SEL_CPLL,
	DCLK_VOP_SRC_SEL_VPLL,
	DCLK_VOP_SRC_SEL_BPLL,
	DCLK_VOP_SRC_SEL_LPLL,
	DCLK0_VOP_SRC_DIV_SHIFT		= 0,
	DCLK0_VOP_SRC_DIV_MASK		= 0xff << DCLK0_VOP_SRC_DIV_SHIFT,

	/* CRU_CLK_SEL147_CON */
	DCLK2_VOP_SEL_SHIFT		= 13,
	DCLK2_VOP_SEL_MASK		= 1 << DCLK2_VOP_SEL_SHIFT,
	DCLK1_VOP_SEL_SHIFT		= 12,
	DCLK1_VOP_SEL_MASK		= 1 << DCLK1_VOP_SEL_SHIFT,
	DCLK0_VOP_SEL_SHIFT		= 11,
	DCLK0_VOP_SEL_MASK		= 1 << DCLK0_VOP_SEL_SHIFT,

	/* CRU_CLK_SEL149_CON */
	ACLK_VO0_ROOT_SEL_SHIFT		= 5,
	ACLK_VO0_ROOT_SEL_MASK		= 3 << ACLK_VO0_ROOT_SEL_SHIFT,
	ACLK_VO0_ROOT_SEL_GPLL		= 0,
	ACLK_VO0_ROOT_SEL_CPLL,
	ACLK_VO0_ROOT_SEL_LPLL,
	ACLK_VO0_ROOT_SEL_BPLL,
	ACLK_VO0_ROOT_DIV_SHIFT		= 0,
	ACLK_VO0_ROOT_DIV_MASK		= 0x1f << ACLK_VO0_ROOT_DIV_SHIFT,

	/* CRU_CLK_SEL151_CON */
	CLK_DSIHOST0_SEL_SHIFT		= 7,
	CLK_DSIHOST0_SEL_MASK		= 7 << CLK_DSIHOST0_SEL_SHIFT,
	CLK_DSIHOST0_SEL_GPLL		= 0,
	CLK_DSIHOST0_SEL_CPLL,
	CLK_DSIHOST0_SEL_SPLL,
	CLK_DSIHOST0_SEL_VPLL,
	CLK_DSIHOST0_SEL_BPLL,
	CLK_DSIHOST0_SEL_LPLL,
	CLK_DSIHOST0_DIV_SHIFT		= 0,
	CLK_DSIHOST0_DIV_MASK		= 0x7f << CLK_DSIHOST0_DIV_SHIFT,

	/* PMUCRU_CLK_SEL5_CON */
	CLK_PMU1PWM_SEL_SHIFT		= 2,
	CLK_PMU1PWM_SEL_MASK		= 3 << CLK_PMU1PWM_SEL_SHIFT,

	/* PMUCRU_CLK_SEL6_CON */
	CLK_I2C0_SEL_SHIFT		= 7,
	CLK_I2C0_SEL_MASK		= 3 << CLK_I2C0_SEL_SHIFT,

	/* PMUCRU_CLK_SEL8_CON */
	CLK_UART1_SEL_SHIFT		= 0,
	CLK_UART1_SEL_MASK		= 1 << CLK_UART1_SEL_SHIFT,
	CLK_UART1_SEL_TOP		= 0,
	CLK_UART1_SEL_OSC,

	/* LITCRU_CLK_SEL0_CON */
	CLK_LITCORE_SEL_SHIFT		= 12,
	CLK_LITCORE_SEL_MASK		= 3 << CLK_LITCORE_SEL_SHIFT,
	CLK_LITCORE_SEL_LPLL		= 0,
	CLK_LITCORE_SEL_GPLL,
	CLK_LITCORE_SEL_PVTPLL,
	CLK_LITCORE_DIV_SHIFT		= 7,
	CLK_LITCORE_DIV_MASK		= 0x1f << CLK_LITCORE_DIV_SHIFT,

};
#endif
