// SPDX-License-Identifier: GPL-2.0
/*
 * Copyright (C) 2022 MediaTek Inc.
 * Author: Sam Shih <sam.shih@mediatek.com>
 */

#include <dm.h>
#include "pinctrl-mtk-common.h"

enum MT7988_PINCTRL_REG_PAGE {
	GPIO_BASE,
	IOCFG_TR_BASE,
	IOCFG_BR_BASE,
	IOCFG_RB_BASE,
	IOCFG_LB_BASE,
	IOCFG_TL_BASE,
};

#define MT7988_TYPE0_PIN(_number, _name)                                       \
	MTK_TYPED_PIN(_number, _name, DRV_GRP4, IO_TYPE_GRP0)

#define MT7988_TYPE1_PIN(_number, _name)                                       \
	MTK_TYPED_PIN(_number, _name, DRV_GRP4, IO_TYPE_GRP1)

#define MT7988_TYPE2_PIN(_number, _name)                                       \
	MTK_TYPED_PIN(_number, _name, DRV_FIXED, IO_TYPE_GRP2)

#define PIN_FIELD_GPIO(_s_pin, _e_pin, _s_addr, _x_addrs, _s_bit, _x_bits)     \
	PIN_FIELD_BASE_CALC(_s_pin, _e_pin, GPIO_BASE, _s_addr, _x_addrs,      \
			    _s_bit, _x_bits, 32, 0)

#define PIN_FIELD_BASE(_s_pin, _e_pin, _i_base, _s_addr, _x_addrs, _s_bit,     \
		       _x_bits)                                                \
	PIN_FIELD_BASE_CALC(_s_pin, _e_pin, _i_base, _s_addr, _x_addrs,        \
			    _s_bit, _x_bits, 32, 0)

#define PINS_FIELD_BASE(_s_pin, _e_pin, _i_base, _s_addr, _x_addrs, _s_bit,    \
			_x_bits)                                               \
	PIN_FIELD_BASE_CALC(_s_pin, _e_pin, _i_base, _s_addr, _x_addrs,        \
			    _s_bit, _x_bits, 32, 1)

static const struct mtk_pin_field_calc mt7988_pin_mode_range[] = {
	PIN_FIELD_GPIO(0, 83, 0x300, 0x10, 0, 4),
};

static const struct mtk_pin_field_calc mt7988_pin_dir_range[] = {
	PIN_FIELD_GPIO(0, 83, 0x0, 0x10, 0, 1),
};

static const struct mtk_pin_field_calc mt7988_pin_di_range[] = {
	PIN_FIELD_GPIO(0, 83, 0x200, 0x10, 0, 1),
};

static const struct mtk_pin_field_calc mt7988_pin_do_range[] = {
	PIN_FIELD_GPIO(0, 83, 0x100, 0x10, 0, 1),
};

static const struct mtk_pin_field_calc mt7988_pin_ies_range[] = {
	PIN_FIELD_BASE(0, 0, IOCFG_TL_BASE, 0x30, 0x10, 13, 1),
	PIN_FIELD_BASE(1, 1, IOCFG_TL_BASE, 0x30, 0x10, 14, 1),
	PIN_FIELD_BASE(2, 2, IOCFG_TL_BASE, 0x30, 0x10, 11, 1),
	PIN_FIELD_BASE(3, 3, IOCFG_TL_BASE, 0x30, 0x10, 12, 1),
	PIN_FIELD_BASE(4, 4, IOCFG_TL_BASE, 0x30, 0x10, 0, 1),
	PIN_FIELD_BASE(5, 5, IOCFG_TL_BASE, 0x30, 0x10, 9, 1),
	PIN_FIELD_BASE(6, 6, IOCFG_TL_BASE, 0x30, 0x10, 10, 1),

	PIN_FIELD_BASE(7, 7, IOCFG_LB_BASE, 0x30, 0x10, 8, 1),
	PIN_FIELD_BASE(8, 8, IOCFG_LB_BASE, 0x30, 0x10, 6, 1),
	PIN_FIELD_BASE(9, 9, IOCFG_LB_BASE, 0x30, 0x10, 5, 1),
	PIN_FIELD_BASE(10, 10, IOCFG_LB_BASE, 0x30, 0x10, 3, 1),

	PIN_FIELD_BASE(11, 11, IOCFG_TR_BASE, 0x40, 0x10, 0, 1),
	PIN_FIELD_BASE(12, 12, IOCFG_TR_BASE, 0x40, 0x10, 21, 1),
	PIN_FIELD_BASE(13, 13, IOCFG_TR_BASE, 0x40, 0x10, 1, 1),
	PIN_FIELD_BASE(14, 14, IOCFG_TR_BASE, 0x40, 0x10, 2, 1),

	PIN_FIELD_BASE(15, 15, IOCFG_TL_BASE, 0x30, 0x10, 7, 1),
	PIN_FIELD_BASE(16, 16, IOCFG_TL_BASE, 0x30, 0x10, 8, 1),
	PIN_FIELD_BASE(17, 17, IOCFG_TL_BASE, 0x30, 0x10, 3, 1),
	PIN_FIELD_BASE(18, 18, IOCFG_TL_BASE, 0x30, 0x10, 4, 1),

	PIN_FIELD_BASE(19, 19, IOCFG_LB_BASE, 0x30, 0x10, 7, 1),
	PIN_FIELD_BASE(20, 20, IOCFG_LB_BASE, 0x30, 0x10, 4, 1),

	PIN_FIELD_BASE(21, 21, IOCFG_RB_BASE, 0x50, 0x10, 17, 1),
	PIN_FIELD_BASE(22, 22, IOCFG_RB_BASE, 0x50, 0x10, 23, 1),
	PIN_FIELD_BASE(23, 23, IOCFG_RB_BASE, 0x50, 0x10, 20, 1),
	PIN_FIELD_BASE(24, 24, IOCFG_RB_BASE, 0x50, 0x10, 19, 1),
	PIN_FIELD_BASE(25, 25, IOCFG_RB_BASE, 0x50, 0x10, 21, 1),
	PIN_FIELD_BASE(26, 26, IOCFG_RB_BASE, 0x50, 0x10, 22, 1),
	PIN_FIELD_BASE(27, 27, IOCFG_RB_BASE, 0x50, 0x10, 18, 1),
	PIN_FIELD_BASE(28, 28, IOCFG_RB_BASE, 0x50, 0x10, 25, 1),
	PIN_FIELD_BASE(29, 29, IOCFG_RB_BASE, 0x50, 0x10, 26, 1),
	PIN_FIELD_BASE(30, 30, IOCFG_RB_BASE, 0x50, 0x10, 27, 1),
	PIN_FIELD_BASE(31, 31, IOCFG_RB_BASE, 0x50, 0x10, 24, 1),
	PIN_FIELD_BASE(32, 32, IOCFG_RB_BASE, 0x50, 0x10, 28, 1),
	PIN_FIELD_BASE(33, 33, IOCFG_RB_BASE, 0x60, 0x10, 0, 1),
	PIN_FIELD_BASE(34, 34, IOCFG_RB_BASE, 0x50, 0x10, 31, 1),
	PIN_FIELD_BASE(35, 35, IOCFG_RB_BASE, 0x50, 0x10, 29, 1),
	PIN_FIELD_BASE(36, 36, IOCFG_RB_BASE, 0x50, 0x10, 30, 1),
	PIN_FIELD_BASE(37, 37, IOCFG_RB_BASE, 0x60, 0x10, 1, 1),
	PIN_FIELD_BASE(38, 38, IOCFG_RB_BASE, 0x50, 0x10, 11, 1),
	PIN_FIELD_BASE(39, 39, IOCFG_RB_BASE, 0x50, 0x10, 10, 1),
	PIN_FIELD_BASE(40, 40, IOCFG_RB_BASE, 0x50, 0x10, 0, 1),
	PIN_FIELD_BASE(41, 41, IOCFG_RB_BASE, 0x50, 0x10, 1, 1),
	PIN_FIELD_BASE(42, 42, IOCFG_RB_BASE, 0x50, 0x10, 9, 1),
	PIN_FIELD_BASE(43, 43, IOCFG_RB_BASE, 0x50, 0x10, 8, 1),
	PIN_FIELD_BASE(44, 44, IOCFG_RB_BASE, 0x50, 0x10, 7, 1),
	PIN_FIELD_BASE(45, 45, IOCFG_RB_BASE, 0x50, 0x10, 6, 1),
	PIN_FIELD_BASE(46, 46, IOCFG_RB_BASE, 0x50, 0x10, 5, 1),
	PIN_FIELD_BASE(47, 47, IOCFG_RB_BASE, 0x50, 0x10, 4, 1),
	PIN_FIELD_BASE(48, 48, IOCFG_RB_BASE, 0x50, 0x10, 3, 1),
	PIN_FIELD_BASE(49, 49, IOCFG_RB_BASE, 0x50, 0x10, 2, 1),
	PIN_FIELD_BASE(50, 50, IOCFG_RB_BASE, 0x50, 0x10, 15, 1),
	PIN_FIELD_BASE(51, 51, IOCFG_RB_BASE, 0x50, 0x10, 12, 1),
	PIN_FIELD_BASE(52, 52, IOCFG_RB_BASE, 0x50, 0x10, 13, 1),
	PIN_FIELD_BASE(53, 53, IOCFG_RB_BASE, 0x50, 0x10, 14, 1),
	PIN_FIELD_BASE(54, 54, IOCFG_RB_BASE, 0x50, 0x10, 16, 1),

	PIN_FIELD_BASE(55, 55, IOCFG_TR_BASE, 0x40, 0x10, 14, 1),
	PIN_FIELD_BASE(56, 56, IOCFG_TR_BASE, 0x40, 0x10, 15, 1),
	PIN_FIELD_BASE(57, 57, IOCFG_TR_BASE, 0x40, 0x10, 13, 1),
	PIN_FIELD_BASE(58, 58, IOCFG_TR_BASE, 0x40, 0x10, 4, 1),
	PIN_FIELD_BASE(59, 59, IOCFG_TR_BASE, 0x40, 0x10, 5, 1),
	PIN_FIELD_BASE(60, 60, IOCFG_TR_BASE, 0x40, 0x10, 6, 1),
	PIN_FIELD_BASE(61, 61, IOCFG_TR_BASE, 0x40, 0x10, 3, 1),
	PIN_FIELD_BASE(62, 62, IOCFG_TR_BASE, 0x40, 0x10, 7, 1),
	PIN_FIELD_BASE(63, 63, IOCFG_TR_BASE, 0x40, 0x10, 20, 1),
	PIN_FIELD_BASE(64, 64, IOCFG_TR_BASE, 0x40, 0x10, 8, 1),
	PIN_FIELD_BASE(65, 65, IOCFG_TR_BASE, 0x40, 0x10, 9, 1),
	PIN_FIELD_BASE(66, 66, IOCFG_TR_BASE, 0x40, 0x10, 10, 1),
	PIN_FIELD_BASE(67, 67, IOCFG_TR_BASE, 0x40, 0x10, 11, 1),
	PIN_FIELD_BASE(68, 68, IOCFG_TR_BASE, 0x40, 0x10, 12, 1),

	PIN_FIELD_BASE(69, 69, IOCFG_TL_BASE, 0x30, 0x10, 1, 1),
	PIN_FIELD_BASE(70, 70, IOCFG_TL_BASE, 0x30, 0x10, 2, 1),
	PIN_FIELD_BASE(71, 71, IOCFG_TL_BASE, 0x30, 0x10, 5, 1),
	PIN_FIELD_BASE(72, 72, IOCFG_TL_BASE, 0x30, 0x10, 6, 1),

	PIN_FIELD_BASE(73, 73, IOCFG_LB_BASE, 0x30, 0x10, 10, 1),
	PIN_FIELD_BASE(74, 74, IOCFG_LB_BASE, 0x30, 0x10, 1, 1),
	PIN_FIELD_BASE(75, 75, IOCFG_LB_BASE, 0x30, 0x10, 11, 1),
	PIN_FIELD_BASE(76, 76, IOCFG_LB_BASE, 0x30, 0x10, 9, 1),
	PIN_FIELD_BASE(77, 77, IOCFG_LB_BASE, 0x30, 0x10, 2, 1),
	PIN_FIELD_BASE(78, 78, IOCFG_LB_BASE, 0x30, 0x10, 0, 1),
	PIN_FIELD_BASE(79, 79, IOCFG_LB_BASE, 0x30, 0x10, 12, 1),

	PIN_FIELD_BASE(80, 80, IOCFG_TR_BASE, 0x40, 0x10, 18, 1),
	PIN_FIELD_BASE(81, 81, IOCFG_TR_BASE, 0x40, 0x10, 19, 1),
	PIN_FIELD_BASE(82, 82, IOCFG_TR_BASE, 0x40, 0x10, 16, 1),
	PIN_FIELD_BASE(83, 83, IOCFG_TR_BASE, 0x40, 0x10, 17, 1),
};

static const struct mtk_pin_field_calc mt7988_pin_smt_range[] = {
	PIN_FIELD_BASE(0, 0, IOCFG_TL_BASE, 0xc0, 0x10, 13, 1),
	PIN_FIELD_BASE(1, 1, IOCFG_TL_BASE, 0xc0, 0x10, 14, 1),
	PIN_FIELD_BASE(2, 2, IOCFG_TL_BASE, 0xc0, 0x10, 11, 1),
	PIN_FIELD_BASE(3, 3, IOCFG_TL_BASE, 0xc0, 0x10, 12, 1),
	PIN_FIELD_BASE(4, 4, IOCFG_TL_BASE, 0xc0, 0x10, 0, 1),
	PIN_FIELD_BASE(5, 5, IOCFG_TL_BASE, 0xc0, 0x10, 9, 1),
	PIN_FIELD_BASE(6, 6, IOCFG_TL_BASE, 0xc0, 0x10, 10, 1),

	PIN_FIELD_BASE(7, 7, IOCFG_LB_BASE, 0xb0, 0x10, 8, 1),
	PIN_FIELD_BASE(8, 8, IOCFG_LB_BASE, 0xb0, 0x10, 6, 1),
	PIN_FIELD_BASE(9, 9, IOCFG_LB_BASE, 0xb0, 0x10, 5, 1),
	PIN_FIELD_BASE(10, 10, IOCFG_LB_BASE, 0xb0, 0x10, 3, 1),

	PIN_FIELD_BASE(11, 11, IOCFG_TR_BASE, 0xe0, 0x10, 0, 1),
	PIN_FIELD_BASE(12, 12, IOCFG_TR_BASE, 0xe0, 0x10, 21, 1),
	PIN_FIELD_BASE(13, 13, IOCFG_TR_BASE, 0xe0, 0x10, 1, 1),
	PIN_FIELD_BASE(14, 14, IOCFG_TR_BASE, 0xe0, 0x10, 2, 1),

	PIN_FIELD_BASE(15, 15, IOCFG_TL_BASE, 0xc0, 0x10, 7, 1),
	PIN_FIELD_BASE(16, 16, IOCFG_TL_BASE, 0xc0, 0x10, 8, 1),
	PIN_FIELD_BASE(17, 17, IOCFG_TL_BASE, 0xc0, 0x10, 3, 1),
	PIN_FIELD_BASE(18, 18, IOCFG_TL_BASE, 0xc0, 0x10, 4, 1),

	PIN_FIELD_BASE(19, 19, IOCFG_LB_BASE, 0xb0, 0x10, 7, 1),
	PIN_FIELD_BASE(20, 20, IOCFG_LB_BASE, 0xb0, 0x10, 4, 1),

	PIN_FIELD_BASE(21, 21, IOCFG_RB_BASE, 0x140, 0x10, 17, 1),
	PIN_FIELD_BASE(22, 22, IOCFG_RB_BASE, 0x140, 0x10, 23, 1),
	PIN_FIELD_BASE(23, 23, IOCFG_RB_BASE, 0x140, 0x10, 20, 1),
	PIN_FIELD_BASE(24, 24, IOCFG_RB_BASE, 0x140, 0x10, 19, 1),
	PIN_FIELD_BASE(25, 25, IOCFG_RB_BASE, 0x140, 0x10, 21, 1),
	PIN_FIELD_BASE(26, 26, IOCFG_RB_BASE, 0x140, 0x10, 22, 1),
	PIN_FIELD_BASE(27, 27, IOCFG_RB_BASE, 0x140, 0x10, 18, 1),
	PIN_FIELD_BASE(28, 28, IOCFG_RB_BASE, 0x140, 0x10, 25, 1),
	PIN_FIELD_BASE(29, 29, IOCFG_RB_BASE, 0x140, 0x10, 26, 1),
	PIN_FIELD_BASE(30, 30, IOCFG_RB_BASE, 0x140, 0x10, 27, 1),
	PIN_FIELD_BASE(31, 31, IOCFG_RB_BASE, 0x140, 0x10, 24, 1),
	PIN_FIELD_BASE(32, 32, IOCFG_RB_BASE, 0x140, 0x10, 28, 1),
	PIN_FIELD_BASE(33, 33, IOCFG_RB_BASE, 0x150, 0x10, 0, 1),
	PIN_FIELD_BASE(34, 34, IOCFG_RB_BASE, 0x140, 0x10, 31, 1),
	PIN_FIELD_BASE(35, 35, IOCFG_RB_BASE, 0x140, 0x10, 29, 1),
	PIN_FIELD_BASE(36, 36, IOCFG_RB_BASE, 0x140, 0x10, 30, 1),
	PIN_FIELD_BASE(37, 37, IOCFG_RB_BASE, 0x150, 0x10, 1, 1),
	PIN_FIELD_BASE(38, 38, IOCFG_RB_BASE, 0x140, 0x10, 11, 1),
	PIN_FIELD_BASE(39, 39, IOCFG_RB_BASE, 0x140, 0x10, 10, 1),
	PIN_FIELD_BASE(40, 40, IOCFG_RB_BASE, 0x140, 0x10, 0, 1),
	PIN_FIELD_BASE(41, 41, IOCFG_RB_BASE, 0x140, 0x10, 1, 1),
	PIN_FIELD_BASE(42, 42, IOCFG_RB_BASE, 0x140, 0x10, 9, 1),
	PIN_FIELD_BASE(43, 43, IOCFG_RB_BASE, 0x140, 0x10, 8, 1),
	PIN_FIELD_BASE(44, 44, IOCFG_RB_BASE, 0x140, 0x10, 7, 1),
	PIN_FIELD_BASE(45, 45, IOCFG_RB_BASE, 0x140, 0x10, 6, 1),
	PIN_FIELD_BASE(46, 46, IOCFG_RB_BASE, 0x140, 0x10, 5, 1),
	PIN_FIELD_BASE(47, 47, IOCFG_RB_BASE, 0x140, 0x10, 4, 1),
	PIN_FIELD_BASE(48, 48, IOCFG_RB_BASE, 0x140, 0x10, 3, 1),
	PIN_FIELD_BASE(49, 49, IOCFG_RB_BASE, 0x140, 0x10, 2, 1),
	PIN_FIELD_BASE(50, 50, IOCFG_RB_BASE, 0x140, 0x10, 15, 1),
	PIN_FIELD_BASE(51, 51, IOCFG_RB_BASE, 0x140, 0x10, 12, 1),
	PIN_FIELD_BASE(52, 52, IOCFG_RB_BASE, 0x140, 0x10, 13, 1),
	PIN_FIELD_BASE(53, 53, IOCFG_RB_BASE, 0x140, 0x10, 14, 1),
	PIN_FIELD_BASE(54, 54, IOCFG_RB_BASE, 0x140, 0x10, 16, 1),

	PIN_FIELD_BASE(55, 55, IOCFG_TR_BASE, 0xe0, 0x10, 14, 1),
	PIN_FIELD_BASE(56, 56, IOCFG_TR_BASE, 0xe0, 0x10, 15, 1),
	PIN_FIELD_BASE(57, 57, IOCFG_TR_BASE, 0xe0, 0x10, 13, 1),
	PIN_FIELD_BASE(58, 58, IOCFG_TR_BASE, 0xe0, 0x10, 4, 1),
	PIN_FIELD_BASE(59, 59, IOCFG_TR_BASE, 0xe0, 0x10, 5, 1),
	PIN_FIELD_BASE(60, 60, IOCFG_TR_BASE, 0xe0, 0x10, 6, 1),
	PIN_FIELD_BASE(61, 61, IOCFG_TR_BASE, 0xe0, 0x10, 3, 1),
	PIN_FIELD_BASE(62, 62, IOCFG_TR_BASE, 0xe0, 0x10, 7, 1),
	PIN_FIELD_BASE(63, 63, IOCFG_TR_BASE, 0xe0, 0x10, 20, 1),
	PIN_FIELD_BASE(64, 64, IOCFG_TR_BASE, 0xe0, 0x10, 8, 1),
	PIN_FIELD_BASE(65, 65, IOCFG_TR_BASE, 0xe0, 0x10, 9, 1),
	PIN_FIELD_BASE(66, 66, IOCFG_TR_BASE, 0xe0, 0x10, 10, 1),
	PIN_FIELD_BASE(67, 67, IOCFG_TR_BASE, 0xe0, 0x10, 11, 1),
	PIN_FIELD_BASE(68, 68, IOCFG_TR_BASE, 0xe0, 0x10, 12, 1),

	PIN_FIELD_BASE(69, 69, IOCFG_TL_BASE, 0xc0, 0x10, 1, 1),
	PIN_FIELD_BASE(70, 70, IOCFG_TL_BASE, 0xc0, 0x10, 2, 1),
	PIN_FIELD_BASE(71, 71, IOCFG_TL_BASE, 0xc0, 0x10, 5, 1),
	PIN_FIELD_BASE(72, 72, IOCFG_TL_BASE, 0xc0, 0x10, 6, 1),

	PIN_FIELD_BASE(73, 73, IOCFG_LB_BASE, 0xb0, 0x10, 10, 1),
	PIN_FIELD_BASE(74, 74, IOCFG_LB_BASE, 0xb0, 0x10, 1, 1),
	PIN_FIELD_BASE(75, 75, IOCFG_LB_BASE, 0xb0, 0x10, 11, 1),
	PIN_FIELD_BASE(76, 76, IOCFG_LB_BASE, 0xb0, 0x10, 9, 1),
	PIN_FIELD_BASE(77, 77, IOCFG_LB_BASE, 0xb0, 0x10, 2, 1),
	PIN_FIELD_BASE(78, 78, IOCFG_LB_BASE, 0xb0, 0x10, 0, 1),
	PIN_FIELD_BASE(79, 79, IOCFG_LB_BASE, 0xb0, 0x10, 12, 1),

	PIN_FIELD_BASE(80, 80, IOCFG_TR_BASE, 0xe0, 0x10, 18, 1),
	PIN_FIELD_BASE(81, 81, IOCFG_TR_BASE, 0xe0, 0x10, 19, 1),
	PIN_FIELD_BASE(82, 82, IOCFG_TR_BASE, 0xe0, 0x10, 16, 1),
	PIN_FIELD_BASE(83, 83, IOCFG_TR_BASE, 0xe0, 0x10, 17, 1),
};

static const struct mtk_pin_field_calc mt7988_pin_pu_range[] = {
	PIN_FIELD_BASE(7, 7, IOCFG_LB_BASE, 0x60, 0x10, 5, 1),
	PIN_FIELD_BASE(8, 8, IOCFG_LB_BASE, 0x60, 0x10, 4, 1),
	PIN_FIELD_BASE(9, 9, IOCFG_LB_BASE, 0x60, 0x10, 3, 1),
	PIN_FIELD_BASE(10, 10, IOCFG_LB_BASE, 0x60, 0x10, 2, 1),

	PIN_FIELD_BASE(13, 13, IOCFG_TR_BASE, 0x70, 0x10, 0, 1),
	PIN_FIELD_BASE(14, 14, IOCFG_TR_BASE, 0x70, 0x10, 1, 1),
	PIN_FIELD_BASE(63, 63, IOCFG_TR_BASE, 0x70, 0x10, 2, 1),

	PIN_FIELD_BASE(75, 75, IOCFG_LB_BASE, 0x60, 0x10, 7, 1),
	PIN_FIELD_BASE(76, 76, IOCFG_LB_BASE, 0x60, 0x10, 6, 1),
	PIN_FIELD_BASE(77, 77, IOCFG_LB_BASE, 0x60, 0x10, 1, 1),
	PIN_FIELD_BASE(78, 78, IOCFG_LB_BASE, 0x60, 0x10, 0, 1),
	PIN_FIELD_BASE(79, 79, IOCFG_LB_BASE, 0x60, 0x10, 8, 1),
};

static const struct mtk_pin_field_calc mt7988_pin_pd_range[] = {
	PIN_FIELD_BASE(7, 7, IOCFG_LB_BASE, 0x40, 0x10, 5, 1),
	PIN_FIELD_BASE(8, 8, IOCFG_LB_BASE, 0x40, 0x10, 4, 1),
	PIN_FIELD_BASE(9, 9, IOCFG_LB_BASE, 0x40, 0x10, 3, 1),
	PIN_FIELD_BASE(10, 10, IOCFG_LB_BASE, 0x40, 0x10, 2, 1),

	PIN_FIELD_BASE(13, 13, IOCFG_TR_BASE, 0x50, 0x10, 0, 1),
	PIN_FIELD_BASE(14, 14, IOCFG_TR_BASE, 0x50, 0x10, 1, 1),

	PIN_FIELD_BASE(15, 15, IOCFG_TL_BASE, 0x40, 0x10, 4, 1),
	PIN_FIELD_BASE(16, 16, IOCFG_TL_BASE, 0x40, 0x10, 5, 1),
	PIN_FIELD_BASE(17, 17, IOCFG_TL_BASE, 0x40, 0x10, 0, 1),
	PIN_FIELD_BASE(18, 18, IOCFG_TL_BASE, 0x40, 0x10, 1, 1),

	PIN_FIELD_BASE(63, 63, IOCFG_TR_BASE, 0x50, 0x10, 2, 1),
	PIN_FIELD_BASE(71, 71, IOCFG_TL_BASE, 0x40, 0x10, 2, 1),
	PIN_FIELD_BASE(72, 72, IOCFG_TL_BASE, 0x40, 0x10, 3, 1),

	PIN_FIELD_BASE(75, 75, IOCFG_LB_BASE, 0x40, 0x10, 7, 1),
	PIN_FIELD_BASE(76, 76, IOCFG_LB_BASE, 0x40, 0x10, 6, 1),
	PIN_FIELD_BASE(77, 77, IOCFG_LB_BASE, 0x40, 0x10, 1, 1),
	PIN_FIELD_BASE(78, 78, IOCFG_LB_BASE, 0x40, 0x10, 0, 1),
	PIN_FIELD_BASE(79, 79, IOCFG_LB_BASE, 0x40, 0x10, 8, 1),
};

static const struct mtk_pin_field_calc mt7988_pin_drv_range[] = {
	PIN_FIELD_BASE(0, 0, IOCFG_TL_BASE, 0x00, 0x10, 21, 3),
	PIN_FIELD_BASE(1, 1, IOCFG_TL_BASE, 0x00, 0x10, 24, 3),
	PIN_FIELD_BASE(2, 2, IOCFG_TL_BASE, 0x00, 0x10, 15, 3),
	PIN_FIELD_BASE(3, 3, IOCFG_TL_BASE, 0x00, 0x10, 18, 3),
	PIN_FIELD_BASE(4, 4, IOCFG_TL_BASE, 0x00, 0x10, 0, 3),
	PIN_FIELD_BASE(5, 5, IOCFG_TL_BASE, 0x00, 0x10, 9, 3),
	PIN_FIELD_BASE(6, 6, IOCFG_TL_BASE, 0x00, 0x10, 12, 3),

	PIN_FIELD_BASE(7, 7, IOCFG_LB_BASE, 0x00, 0x10, 24, 3),
	PIN_FIELD_BASE(8, 8, IOCFG_LB_BASE, 0x00, 0x10, 28, 3),
	PIN_FIELD_BASE(9, 9, IOCFG_LB_BASE, 0x00, 0x10, 15, 3),
	PIN_FIELD_BASE(10, 10, IOCFG_LB_BASE, 0x00, 0x10, 9, 3),

	PIN_FIELD_BASE(11, 11, IOCFG_TR_BASE, 0x00, 0x10, 0, 3),
	PIN_FIELD_BASE(12, 12, IOCFG_TR_BASE, 0x20, 0x10, 3, 3),
	PIN_FIELD_BASE(13, 13, IOCFG_TR_BASE, 0x00, 0x10, 3, 3),
	PIN_FIELD_BASE(14, 14, IOCFG_TR_BASE, 0x00, 0x10, 6, 3),

	PIN_FIELD_BASE(19, 19, IOCFG_LB_BASE, 0x00, 0x10, 21, 3),
	PIN_FIELD_BASE(20, 20, IOCFG_LB_BASE, 0x00, 0x10, 12, 3),

	PIN_FIELD_BASE(21, 21, IOCFG_RB_BASE, 0x10, 0x10, 21, 3),
	PIN_FIELD_BASE(22, 22, IOCFG_RB_BASE, 0x20, 0x10, 9, 3),
	PIN_FIELD_BASE(23, 23, IOCFG_RB_BASE, 0x20, 0x10, 0, 3),
	PIN_FIELD_BASE(24, 24, IOCFG_RB_BASE, 0x10, 0x10, 27, 3),
	PIN_FIELD_BASE(25, 25, IOCFG_RB_BASE, 0x20, 0x10, 3, 3),
	PIN_FIELD_BASE(26, 26, IOCFG_RB_BASE, 0x20, 0x10, 6, 3),
	PIN_FIELD_BASE(27, 27, IOCFG_RB_BASE, 0x10, 0x10, 24, 3),
	PIN_FIELD_BASE(28, 28, IOCFG_RB_BASE, 0x20, 0x10, 15, 3),
	PIN_FIELD_BASE(29, 29, IOCFG_RB_BASE, 0x20, 0x10, 18, 3),
	PIN_FIELD_BASE(30, 30, IOCFG_RB_BASE, 0x20, 0x10, 21, 3),
	PIN_FIELD_BASE(31, 31, IOCFG_RB_BASE, 0x20, 0x10, 12, 3),
	PIN_FIELD_BASE(32, 32, IOCFG_RB_BASE, 0x20, 0x10, 24, 3),
	PIN_FIELD_BASE(33, 33, IOCFG_RB_BASE, 0x30, 0x10, 6, 3),
	PIN_FIELD_BASE(34, 34, IOCFG_RB_BASE, 0x30, 0x10, 3, 3),
	PIN_FIELD_BASE(35, 35, IOCFG_RB_BASE, 0x20, 0x10, 27, 3),
	PIN_FIELD_BASE(36, 36, IOCFG_RB_BASE, 0x30, 0x10, 0, 3),
	PIN_FIELD_BASE(37, 37, IOCFG_RB_BASE, 0x30, 0x10, 9, 3),
	PIN_FIELD_BASE(38, 38, IOCFG_RB_BASE, 0x10, 0x10, 3, 3),
	PIN_FIELD_BASE(39, 39, IOCFG_RB_BASE, 0x10, 0x10, 0, 3),
	PIN_FIELD_BASE(40, 40, IOCFG_RB_BASE, 0x00, 0x10, 0, 3),
	PIN_FIELD_BASE(41, 41, IOCFG_RB_BASE, 0x00, 0x10, 3, 3),
	PIN_FIELD_BASE(42, 42, IOCFG_RB_BASE, 0x00, 0x10, 27, 3),
	PIN_FIELD_BASE(43, 43, IOCFG_RB_BASE, 0x00, 0x10, 24, 3),
	PIN_FIELD_BASE(44, 44, IOCFG_RB_BASE, 0x00, 0x10, 21, 3),
	PIN_FIELD_BASE(45, 45, IOCFG_RB_BASE, 0x00, 0x10, 18, 3),
	PIN_FIELD_BASE(46, 46, IOCFG_RB_BASE, 0x00, 0x10, 15, 3),
	PIN_FIELD_BASE(47, 47, IOCFG_RB_BASE, 0x00, 0x10, 12, 3),
	PIN_FIELD_BASE(48, 48, IOCFG_RB_BASE, 0x00, 0x10, 9, 3),
	PIN_FIELD_BASE(49, 49, IOCFG_RB_BASE, 0x00, 0x10, 6, 3),
	PIN_FIELD_BASE(50, 50, IOCFG_RB_BASE, 0x10, 0x10, 15, 3),
	PIN_FIELD_BASE(51, 51, IOCFG_RB_BASE, 0x10, 0x10, 6, 3),
	PIN_FIELD_BASE(52, 52, IOCFG_RB_BASE, 0x10, 0x10, 9, 3),
	PIN_FIELD_BASE(53, 53, IOCFG_RB_BASE, 0x10, 0x10, 12, 3),
	PIN_FIELD_BASE(54, 54, IOCFG_RB_BASE, 0x10, 0x10, 18, 3),

	PIN_FIELD_BASE(55, 55, IOCFG_TR_BASE, 0x10, 0x10, 12, 3),
	PIN_FIELD_BASE(56, 56, IOCFG_TR_BASE, 0x10, 0x10, 15, 3),
	PIN_FIELD_BASE(57, 57, IOCFG_TR_BASE, 0x10, 0x10, 9, 3),
	PIN_FIELD_BASE(58, 58, IOCFG_TR_BASE, 0x00, 0x10, 12, 3),
	PIN_FIELD_BASE(59, 59, IOCFG_TR_BASE, 0x00, 0x10, 15, 3),
	PIN_FIELD_BASE(60, 60, IOCFG_TR_BASE, 0x00, 0x10, 18, 3),
	PIN_FIELD_BASE(61, 61, IOCFG_TR_BASE, 0x00, 0x10, 9, 3),
	PIN_FIELD_BASE(62, 62, IOCFG_TR_BASE, 0x00, 0x10, 21, 3),
	PIN_FIELD_BASE(63, 63, IOCFG_TR_BASE, 0x20, 0x10, 0, 3),
	PIN_FIELD_BASE(64, 64, IOCFG_TR_BASE, 0x00, 0x10, 24, 3),
	PIN_FIELD_BASE(65, 65, IOCFG_TR_BASE, 0x00, 0x10, 27, 3),
	PIN_FIELD_BASE(66, 66, IOCFG_TR_BASE, 0x10, 0x10, 0, 3),
	PIN_FIELD_BASE(67, 67, IOCFG_TR_BASE, 0x10, 0x10, 3, 3),
	PIN_FIELD_BASE(68, 68, IOCFG_TR_BASE, 0x10, 0x10, 6, 3),

	PIN_FIELD_BASE(69, 69, IOCFG_TL_BASE, 0x00, 0x10, 3, 3),
	PIN_FIELD_BASE(70, 70, IOCFG_TL_BASE, 0x00, 0x10, 6, 3),

	PIN_FIELD_BASE(73, 73, IOCFG_LB_BASE, 0x10, 0x10, 0, 3),
	PIN_FIELD_BASE(74, 74, IOCFG_LB_BASE, 0x00, 0x10, 3, 3),
	PIN_FIELD_BASE(75, 75, IOCFG_LB_BASE, 0x10, 0x10, 3, 3),
	PIN_FIELD_BASE(76, 76, IOCFG_LB_BASE, 0x00, 0x10, 27, 3),
	PIN_FIELD_BASE(77, 77, IOCFG_LB_BASE, 0x00, 0x10, 6, 3),
	PIN_FIELD_BASE(78, 78, IOCFG_LB_BASE, 0x00, 0x10, 0, 3),
	PIN_FIELD_BASE(79, 79, IOCFG_LB_BASE, 0x10, 0x10, 6, 3),

	PIN_FIELD_BASE(80, 80, IOCFG_TR_BASE, 0x10, 0x10, 24, 3),
	PIN_FIELD_BASE(81, 81, IOCFG_TR_BASE, 0x10, 0x10, 27, 3),
	PIN_FIELD_BASE(82, 82, IOCFG_TR_BASE, 0x10, 0x10, 18, 3),
	PIN_FIELD_BASE(83, 83, IOCFG_TR_BASE, 0x10, 0x10, 21, 3),
};

static const struct mtk_pin_field_calc mt7988_pin_pupd_range[] = {
	PIN_FIELD_BASE(0, 0, IOCFG_TL_BASE, 0x50, 0x10, 7, 1),
	PIN_FIELD_BASE(1, 1, IOCFG_TL_BASE, 0x50, 0x10, 8, 1),
	PIN_FIELD_BASE(2, 2, IOCFG_TL_BASE, 0x50, 0x10, 5, 1),
	PIN_FIELD_BASE(3, 3, IOCFG_TL_BASE, 0x50, 0x10, 6, 1),
	PIN_FIELD_BASE(4, 4, IOCFG_TL_BASE, 0x50, 0x10, 0, 1),
	PIN_FIELD_BASE(5, 5, IOCFG_TL_BASE, 0x50, 0x10, 3, 1),
	PIN_FIELD_BASE(6, 6, IOCFG_TL_BASE, 0x50, 0x10, 4, 1),

	PIN_FIELD_BASE(11, 11, IOCFG_TR_BASE, 0x60, 0x10, 0, 1),
	PIN_FIELD_BASE(12, 12, IOCFG_TR_BASE, 0x60, 0x10, 18, 1),

	PIN_FIELD_BASE(19, 19, IOCFG_LB_BASE, 0x50, 0x10, 2, 1),
	PIN_FIELD_BASE(20, 20, IOCFG_LB_BASE, 0x50, 0x10, 1, 1),

	PIN_FIELD_BASE(21, 21, IOCFG_RB_BASE, 0x70, 0x10, 17, 1),
	PIN_FIELD_BASE(22, 22, IOCFG_RB_BASE, 0x70, 0x10, 23, 1),
	PIN_FIELD_BASE(23, 23, IOCFG_RB_BASE, 0x70, 0x10, 20, 1),
	PIN_FIELD_BASE(24, 24, IOCFG_RB_BASE, 0x70, 0x10, 19, 1),
	PIN_FIELD_BASE(25, 25, IOCFG_RB_BASE, 0x70, 0x10, 21, 1),
	PIN_FIELD_BASE(26, 26, IOCFG_RB_BASE, 0x70, 0x10, 22, 1),
	PIN_FIELD_BASE(27, 27, IOCFG_RB_BASE, 0x70, 0x10, 18, 1),
	PIN_FIELD_BASE(28, 28, IOCFG_RB_BASE, 0x70, 0x10, 25, 1),
	PIN_FIELD_BASE(29, 29, IOCFG_RB_BASE, 0x70, 0x10, 26, 1),
	PIN_FIELD_BASE(30, 30, IOCFG_RB_BASE, 0x70, 0x10, 27, 1),
	PIN_FIELD_BASE(31, 31, IOCFG_RB_BASE, 0x70, 0x10, 24, 1),
	PIN_FIELD_BASE(32, 32, IOCFG_RB_BASE, 0x70, 0x10, 28, 1),
	PIN_FIELD_BASE(33, 33, IOCFG_RB_BASE, 0x80, 0x10, 0, 1),
	PIN_FIELD_BASE(34, 34, IOCFG_RB_BASE, 0x70, 0x10, 31, 1),
	PIN_FIELD_BASE(35, 35, IOCFG_RB_BASE, 0x70, 0x10, 29, 1),
	PIN_FIELD_BASE(36, 36, IOCFG_RB_BASE, 0x70, 0x10, 30, 1),
	PIN_FIELD_BASE(37, 37, IOCFG_RB_BASE, 0x80, 0x10, 1, 1),
	PIN_FIELD_BASE(38, 38, IOCFG_RB_BASE, 0x70, 0x10, 11, 1),
	PIN_FIELD_BASE(39, 39, IOCFG_RB_BASE, 0x70, 0x10, 10, 1),
	PIN_FIELD_BASE(40, 40, IOCFG_RB_BASE, 0x70, 0x10, 0, 1),
	PIN_FIELD_BASE(41, 41, IOCFG_RB_BASE, 0x70, 0x10, 1, 1),
	PIN_FIELD_BASE(42, 42, IOCFG_RB_BASE, 0x70, 0x10, 9, 1),
	PIN_FIELD_BASE(43, 43, IOCFG_RB_BASE, 0x70, 0x10, 8, 1),
	PIN_FIELD_BASE(44, 44, IOCFG_RB_BASE, 0x70, 0x10, 7, 1),
	PIN_FIELD_BASE(45, 45, IOCFG_RB_BASE, 0x70, 0x10, 6, 1),
	PIN_FIELD_BASE(46, 46, IOCFG_RB_BASE, 0x70, 0x10, 5, 1),
	PIN_FIELD_BASE(47, 47, IOCFG_RB_BASE, 0x70, 0x10, 4, 1),
	PIN_FIELD_BASE(48, 48, IOCFG_RB_BASE, 0x70, 0x10, 3, 1),
	PIN_FIELD_BASE(49, 49, IOCFG_RB_BASE, 0x70, 0x10, 2, 1),
	PIN_FIELD_BASE(50, 50, IOCFG_RB_BASE, 0x70, 0x10, 15, 1),
	PIN_FIELD_BASE(51, 51, IOCFG_RB_BASE, 0x70, 0x10, 12, 1),
	PIN_FIELD_BASE(52, 52, IOCFG_RB_BASE, 0x70, 0x10, 13, 1),
	PIN_FIELD_BASE(53, 53, IOCFG_RB_BASE, 0x70, 0x10, 14, 1),
	PIN_FIELD_BASE(54, 54, IOCFG_RB_BASE, 0x70, 0x10, 16, 1),

	PIN_FIELD_BASE(55, 55, IOCFG_TR_BASE, 0x60, 0x10, 12, 1),
	PIN_FIELD_BASE(56, 56, IOCFG_TR_BASE, 0x60, 0x10, 13, 1),
	PIN_FIELD_BASE(57, 57, IOCFG_TR_BASE, 0x60, 0x10, 11, 1),
	PIN_FIELD_BASE(58, 58, IOCFG_TR_BASE, 0x60, 0x10, 2, 1),
	PIN_FIELD_BASE(59, 59, IOCFG_TR_BASE, 0x60, 0x10, 3, 1),
	PIN_FIELD_BASE(60, 60, IOCFG_TR_BASE, 0x60, 0x10, 4, 1),
	PIN_FIELD_BASE(61, 61, IOCFG_TR_BASE, 0x60, 0x10, 1, 1),
	PIN_FIELD_BASE(62, 62, IOCFG_TR_BASE, 0x60, 0x10, 5, 1),
	PIN_FIELD_BASE(64, 64, IOCFG_TR_BASE, 0x60, 0x10, 6, 1),
	PIN_FIELD_BASE(65, 65, IOCFG_TR_BASE, 0x60, 0x10, 7, 1),
	PIN_FIELD_BASE(66, 66, IOCFG_TR_BASE, 0x60, 0x10, 8, 1),
	PIN_FIELD_BASE(67, 67, IOCFG_TR_BASE, 0x60, 0x10, 9, 1),
	PIN_FIELD_BASE(68, 68, IOCFG_TR_BASE, 0x60, 0x10, 10, 1),

	PIN_FIELD_BASE(69, 69, IOCFG_TL_BASE, 0x50, 0x10, 1, 1),
	PIN_FIELD_BASE(70, 70, IOCFG_TL_BASE, 0x50, 0x10, 2, 1),

	PIN_FIELD_BASE(73, 73, IOCFG_LB_BASE, 0x50, 0x10, 3, 1),
	PIN_FIELD_BASE(74, 74, IOCFG_LB_BASE, 0x50, 0x10, 0, 1),

	PIN_FIELD_BASE(80, 80, IOCFG_TR_BASE, 0x60, 0x10, 16, 1),
	PIN_FIELD_BASE(81, 81, IOCFG_TR_BASE, 0x60, 0x10, 17, 1),
	PIN_FIELD_BASE(82, 82, IOCFG_TR_BASE, 0x60, 0x10, 14, 1),
	PIN_FIELD_BASE(83, 83, IOCFG_TR_BASE, 0x60, 0x10, 15, 1),
};

static const struct mtk_pin_field_calc mt7988_pin_r0_range[] = {
	PIN_FIELD_BASE(0, 0, IOCFG_TL_BASE, 0x60, 0x10, 7, 1),
	PIN_FIELD_BASE(1, 1, IOCFG_TL_BASE, 0x60, 0x10, 8, 1),
	PIN_FIELD_BASE(2, 2, IOCFG_TL_BASE, 0x60, 0x10, 5, 1),
	PIN_FIELD_BASE(3, 3, IOCFG_TL_BASE, 0x60, 0x10, 6, 1),
	PIN_FIELD_BASE(4, 4, IOCFG_TL_BASE, 0x60, 0x10, 0, 1),
	PIN_FIELD_BASE(5, 5, IOCFG_TL_BASE, 0x60, 0x10, 3, 1),
	PIN_FIELD_BASE(6, 6, IOCFG_TL_BASE, 0x60, 0x10, 4, 1),

	PIN_FIELD_BASE(11, 11, IOCFG_TR_BASE, 0x80, 0x10, 0, 1),
	PIN_FIELD_BASE(12, 12, IOCFG_TR_BASE, 0x80, 0x10, 18, 1),

	PIN_FIELD_BASE(19, 19, IOCFG_LB_BASE, 0x70, 0x10, 2, 1),
	PIN_FIELD_BASE(20, 20, IOCFG_LB_BASE, 0x70, 0x10, 1, 1),

	PIN_FIELD_BASE(21, 21, IOCFG_RB_BASE, 0x90, 0x10, 17, 1),
	PIN_FIELD_BASE(22, 22, IOCFG_RB_BASE, 0x90, 0x10, 23, 1),
	PIN_FIELD_BASE(23, 23, IOCFG_RB_BASE, 0x90, 0x10, 20, 1),
	PIN_FIELD_BASE(24, 24, IOCFG_RB_BASE, 0x90, 0x10, 19, 1),
	PIN_FIELD_BASE(25, 25, IOCFG_RB_BASE, 0x90, 0x10, 21, 1),
	PIN_FIELD_BASE(26, 26, IOCFG_RB_BASE, 0x90, 0x10, 22, 1),
	PIN_FIELD_BASE(27, 27, IOCFG_RB_BASE, 0x90, 0x10, 18, 1),
	PIN_FIELD_BASE(28, 28, IOCFG_RB_BASE, 0x90, 0x10, 25, 1),
	PIN_FIELD_BASE(29, 29, IOCFG_RB_BASE, 0x90, 0x10, 26, 1),
	PIN_FIELD_BASE(30, 30, IOCFG_RB_BASE, 0x90, 0x10, 27, 1),
	PIN_FIELD_BASE(31, 31, IOCFG_RB_BASE, 0x90, 0x10, 24, 1),
	PIN_FIELD_BASE(32, 32, IOCFG_RB_BASE, 0x90, 0x10, 28, 1),
	PIN_FIELD_BASE(33, 33, IOCFG_RB_BASE, 0xa0, 0x10, 0, 1),
	PIN_FIELD_BASE(34, 34, IOCFG_RB_BASE, 0x90, 0x10, 31, 1),
	PIN_FIELD_BASE(35, 35, IOCFG_RB_BASE, 0x90, 0x10, 29, 1),
	PIN_FIELD_BASE(36, 36, IOCFG_RB_BASE, 0x90, 0x10, 30, 1),
	PIN_FIELD_BASE(37, 37, IOCFG_RB_BASE, 0xa0, 0x10, 1, 1),
	PIN_FIELD_BASE(38, 38, IOCFG_RB_BASE, 0x90, 0x10, 11, 1),
	PIN_FIELD_BASE(39, 39, IOCFG_RB_BASE, 0x90, 0x10, 10, 1),
	PIN_FIELD_BASE(40, 40, IOCFG_RB_BASE, 0x90, 0x10, 0, 1),
	PIN_FIELD_BASE(41, 41, IOCFG_RB_BASE, 0x90, 0x10, 1, 1),
	PIN_FIELD_BASE(42, 42, IOCFG_RB_BASE, 0x90, 0x10, 9, 1),
	PIN_FIELD_BASE(43, 43, IOCFG_RB_BASE, 0x90, 0x10, 8, 1),
	PIN_FIELD_BASE(44, 44, IOCFG_RB_BASE, 0x90, 0x10, 7, 1),
	PIN_FIELD_BASE(45, 45, IOCFG_RB_BASE, 0x90, 0x10, 6, 1),
	PIN_FIELD_BASE(46, 46, IOCFG_RB_BASE, 0x90, 0x10, 5, 1),
	PIN_FIELD_BASE(47, 47, IOCFG_RB_BASE, 0x90, 0x10, 4, 1),
	PIN_FIELD_BASE(48, 48, IOCFG_RB_BASE, 0x90, 0x10, 3, 1),
	PIN_FIELD_BASE(49, 49, IOCFG_RB_BASE, 0x90, 0x10, 2, 1),
	PIN_FIELD_BASE(50, 50, IOCFG_RB_BASE, 0x90, 0x10, 15, 1),
	PIN_FIELD_BASE(51, 51, IOCFG_RB_BASE, 0x90, 0x10, 12, 1),
	PIN_FIELD_BASE(52, 52, IOCFG_RB_BASE, 0x90, 0x10, 13, 1),
	PIN_FIELD_BASE(53, 53, IOCFG_RB_BASE, 0x90, 0x10, 14, 1),
	PIN_FIELD_BASE(54, 54, IOCFG_RB_BASE, 0x90, 0x10, 16, 1),

	PIN_FIELD_BASE(55, 55, IOCFG_TR_BASE, 0x80, 0x10, 12, 1),
	PIN_FIELD_BASE(56, 56, IOCFG_TR_BASE, 0x80, 0x10, 13, 1),
	PIN_FIELD_BASE(57, 57, IOCFG_TR_BASE, 0x80, 0x10, 11, 1),
	PIN_FIELD_BASE(58, 58, IOCFG_TR_BASE, 0x80, 0x10, 2, 1),
	PIN_FIELD_BASE(59, 59, IOCFG_TR_BASE, 0x80, 0x10, 3, 1),
	PIN_FIELD_BASE(60, 60, IOCFG_TR_BASE, 0x80, 0x10, 4, 1),
	PIN_FIELD_BASE(61, 61, IOCFG_TR_BASE, 0x80, 0x10, 1, 1),
	PIN_FIELD_BASE(62, 62, IOCFG_TR_BASE, 0x80, 0x10, 5, 1),
	PIN_FIELD_BASE(64, 64, IOCFG_TR_BASE, 0x80, 0x10, 6, 1),
	PIN_FIELD_BASE(65, 65, IOCFG_TR_BASE, 0x80, 0x10, 7, 1),
	PIN_FIELD_BASE(66, 66, IOCFG_TR_BASE, 0x80, 0x10, 8, 1),
	PIN_FIELD_BASE(67, 67, IOCFG_TR_BASE, 0x80, 0x10, 9, 1),
	PIN_FIELD_BASE(68, 68, IOCFG_TR_BASE, 0x80, 0x10, 10, 1),

	PIN_FIELD_BASE(69, 69, IOCFG_TL_BASE, 0x60, 0x10, 1, 1),
	PIN_FIELD_BASE(70, 70, IOCFG_TL_BASE, 0x60, 0x10, 2, 1),

	PIN_FIELD_BASE(73, 73, IOCFG_LB_BASE, 0x70, 0x10, 3, 1),
	PIN_FIELD_BASE(74, 74, IOCFG_LB_BASE, 0x70, 0x10, 0, 1),

	PIN_FIELD_BASE(80, 80, IOCFG_TR_BASE, 0x80, 0x10, 16, 1),
	PIN_FIELD_BASE(81, 81, IOCFG_TR_BASE, 0x80, 0x10, 17, 1),
	PIN_FIELD_BASE(82, 82, IOCFG_TR_BASE, 0x80, 0x10, 14, 1),
	PIN_FIELD_BASE(83, 83, IOCFG_TR_BASE, 0x80, 0x10, 15, 1),
};

static const struct mtk_pin_field_calc mt7988_pin_r1_range[] = {
	PIN_FIELD_BASE(0, 0, IOCFG_TL_BASE, 0x70, 0x10, 7, 1),
	PIN_FIELD_BASE(1, 1, IOCFG_TL_BASE, 0x70, 0x10, 8, 1),
	PIN_FIELD_BASE(2, 2, IOCFG_TL_BASE, 0x70, 0x10, 5, 1),
	PIN_FIELD_BASE(3, 3, IOCFG_TL_BASE, 0x70, 0x10, 6, 1),
	PIN_FIELD_BASE(4, 4, IOCFG_TL_BASE, 0x70, 0x10, 0, 1),
	PIN_FIELD_BASE(5, 5, IOCFG_TL_BASE, 0x70, 0x10, 3, 1),
	PIN_FIELD_BASE(6, 6, IOCFG_TL_BASE, 0x70, 0x10, 4, 1),

	PIN_FIELD_BASE(11, 11, IOCFG_TR_BASE, 0x90, 0x10, 0, 1),
	PIN_FIELD_BASE(12, 12, IOCFG_TR_BASE, 0x90, 0x10, 18, 1),

	PIN_FIELD_BASE(19, 19, IOCFG_LB_BASE, 0x80, 0x10, 2, 1),
	PIN_FIELD_BASE(20, 20, IOCFG_LB_BASE, 0x80, 0x10, 1, 1),

	PIN_FIELD_BASE(21, 21, IOCFG_RB_BASE, 0xb0, 0x10, 17, 1),
	PIN_FIELD_BASE(22, 22, IOCFG_RB_BASE, 0xb0, 0x10, 23, 1),
	PIN_FIELD_BASE(23, 23, IOCFG_RB_BASE, 0xb0, 0x10, 20, 1),
	PIN_FIELD_BASE(24, 24, IOCFG_RB_BASE, 0xb0, 0x10, 19, 1),
	PIN_FIELD_BASE(25, 25, IOCFG_RB_BASE, 0xb0, 0x10, 21, 1),
	PIN_FIELD_BASE(26, 26, IOCFG_RB_BASE, 0xb0, 0x10, 22, 1),
	PIN_FIELD_BASE(27, 27, IOCFG_RB_BASE, 0xb0, 0x10, 18, 1),
	PIN_FIELD_BASE(28, 28, IOCFG_RB_BASE, 0xb0, 0x10, 25, 1),
	PIN_FIELD_BASE(29, 29, IOCFG_RB_BASE, 0xb0, 0x10, 26, 1),
	PIN_FIELD_BASE(30, 30, IOCFG_RB_BASE, 0xb0, 0x10, 27, 1),
	PIN_FIELD_BASE(31, 31, IOCFG_RB_BASE, 0xb0, 0x10, 24, 1),
	PIN_FIELD_BASE(32, 32, IOCFG_RB_BASE, 0xb0, 0x10, 28, 1),
	PIN_FIELD_BASE(33, 33, IOCFG_RB_BASE, 0xc0, 0x10, 0, 1),
	PIN_FIELD_BASE(34, 34, IOCFG_RB_BASE, 0xb0, 0x10, 31, 1),
	PIN_FIELD_BASE(35, 35, IOCFG_RB_BASE, 0xb0, 0x10, 29, 1),
	PIN_FIELD_BASE(36, 36, IOCFG_RB_BASE, 0xb0, 0x10, 30, 1),
	PIN_FIELD_BASE(37, 37, IOCFG_RB_BASE, 0xc0, 0x10, 1, 1),
	PIN_FIELD_BASE(38, 38, IOCFG_RB_BASE, 0xb0, 0x10, 11, 1),
	PIN_FIELD_BASE(39, 39, IOCFG_RB_BASE, 0xb0, 0x10, 10, 1),
	PIN_FIELD_BASE(40, 40, IOCFG_RB_BASE, 0xb0, 0x10, 0, 1),
	PIN_FIELD_BASE(41, 41, IOCFG_RB_BASE, 0xb0, 0x10, 1, 1),
	PIN_FIELD_BASE(42, 42, IOCFG_RB_BASE, 0xb0, 0x10, 9, 1),
	PIN_FIELD_BASE(43, 43, IOCFG_RB_BASE, 0xb0, 0x10, 8, 1),
	PIN_FIELD_BASE(44, 44, IOCFG_RB_BASE, 0xb0, 0x10, 7, 1),
	PIN_FIELD_BASE(45, 45, IOCFG_RB_BASE, 0xb0, 0x10, 6, 1),
	PIN_FIELD_BASE(46, 46, IOCFG_RB_BASE, 0xb0, 0x10, 5, 1),
	PIN_FIELD_BASE(47, 47, IOCFG_RB_BASE, 0xb0, 0x10, 4, 1),
	PIN_FIELD_BASE(48, 48, IOCFG_RB_BASE, 0xb0, 0x10, 3, 1),
	PIN_FIELD_BASE(49, 49, IOCFG_RB_BASE, 0xb0, 0x10, 2, 1),
	PIN_FIELD_BASE(50, 50, IOCFG_RB_BASE, 0xb0, 0x10, 15, 1),
	PIN_FIELD_BASE(51, 51, IOCFG_RB_BASE, 0xb0, 0x10, 12, 1),
	PIN_FIELD_BASE(52, 52, IOCFG_RB_BASE, 0xb0, 0x10, 13, 1),
	PIN_FIELD_BASE(53, 53, IOCFG_RB_BASE, 0xb0, 0x10, 14, 1),
	PIN_FIELD_BASE(54, 54, IOCFG_RB_BASE, 0xb0, 0x10, 16, 1),

	PIN_FIELD_BASE(55, 55, IOCFG_TR_BASE, 0x90, 0x10, 12, 1),
	PIN_FIELD_BASE(56, 56, IOCFG_TR_BASE, 0x90, 0x10, 13, 1),
	PIN_FIELD_BASE(57, 57, IOCFG_TR_BASE, 0x90, 0x10, 11, 1),
	PIN_FIELD_BASE(58, 58, IOCFG_TR_BASE, 0x90, 0x10, 2, 1),
	PIN_FIELD_BASE(59, 59, IOCFG_TR_BASE, 0x90, 0x10, 3, 1),
	PIN_FIELD_BASE(60, 60, IOCFG_TR_BASE, 0x90, 0x10, 4, 1),
	PIN_FIELD_BASE(61, 61, IOCFG_TR_BASE, 0x90, 0x10, 1, 1),
	PIN_FIELD_BASE(62, 62, IOCFG_TR_BASE, 0x90, 0x10, 5, 1),
	PIN_FIELD_BASE(64, 64, IOCFG_TR_BASE, 0x90, 0x10, 6, 1),
	PIN_FIELD_BASE(65, 65, IOCFG_TR_BASE, 0x90, 0x10, 7, 1),
	PIN_FIELD_BASE(66, 66, IOCFG_TR_BASE, 0x90, 0x10, 8, 1),
	PIN_FIELD_BASE(67, 67, IOCFG_TR_BASE, 0x90, 0x10, 9, 1),
	PIN_FIELD_BASE(68, 68, IOCFG_TR_BASE, 0x90, 0x10, 10, 1),

	PIN_FIELD_BASE(69, 69, IOCFG_TL_BASE, 0x70, 0x10, 1, 1),
	PIN_FIELD_BASE(70, 70, IOCFG_TL_BASE, 0x70, 0x10, 2, 1),

	PIN_FIELD_BASE(73, 73, IOCFG_LB_BASE, 0x80, 0x10, 3, 1),
	PIN_FIELD_BASE(74, 74, IOCFG_LB_BASE, 0x80, 0x10, 0, 1),

	PIN_FIELD_BASE(80, 80, IOCFG_TR_BASE, 0x90, 0x10, 16, 1),
	PIN_FIELD_BASE(81, 81, IOCFG_TR_BASE, 0x90, 0x10, 17, 1),
	PIN_FIELD_BASE(82, 82, IOCFG_TR_BASE, 0x90, 0x10, 14, 1),
	PIN_FIELD_BASE(83, 83, IOCFG_TR_BASE, 0x90, 0x10, 15, 1),
};

static const struct mtk_pin_reg_calc mt7988_reg_cals[PINCTRL_PIN_REG_MAX] = {
	[PINCTRL_PIN_REG_MODE] = MTK_RANGE(mt7988_pin_mode_range),
	[PINCTRL_PIN_REG_DIR] = MTK_RANGE(mt7988_pin_dir_range),
	[PINCTRL_PIN_REG_DI] = MTK_RANGE(mt7988_pin_di_range),
	[PINCTRL_PIN_REG_DO] = MTK_RANGE(mt7988_pin_do_range),
	[PINCTRL_PIN_REG_SMT] = MTK_RANGE(mt7988_pin_smt_range),
	[PINCTRL_PIN_REG_IES] = MTK_RANGE(mt7988_pin_ies_range),
	[PINCTRL_PIN_REG_PU] = MTK_RANGE(mt7988_pin_pu_range),
	[PINCTRL_PIN_REG_PD] = MTK_RANGE(mt7988_pin_pd_range),
	[PINCTRL_PIN_REG_DRV] = MTK_RANGE(mt7988_pin_drv_range),
	[PINCTRL_PIN_REG_PUPD] = MTK_RANGE(mt7988_pin_pupd_range),
	[PINCTRL_PIN_REG_R0] = MTK_RANGE(mt7988_pin_r0_range),
	[PINCTRL_PIN_REG_R1] = MTK_RANGE(mt7988_pin_r1_range),
};

static const struct mtk_pin_desc mt7988_pins[] = {
	MT7988_TYPE0_PIN(0, "UART2_RXD"),
	MT7988_TYPE0_PIN(1, "UART2_TXD"),
	MT7988_TYPE0_PIN(2, "UART2_CTS"),
	MT7988_TYPE0_PIN(3, "UART2_RTS"),
	MT7988_TYPE0_PIN(4, "GPIO_A"),
	MT7988_TYPE0_PIN(5, "SMI_0_MDC"),
	MT7988_TYPE0_PIN(6, "SMI_0_MDIO"),
	MT7988_TYPE1_PIN(7, "PCIE30_2L_0_WAKE_N"),
	MT7988_TYPE1_PIN(8, "PCIE30_2L_0_CLKREQ_N"),
	MT7988_TYPE1_PIN(9, "PCIE30_1L_1_WAKE_N"),
	MT7988_TYPE1_PIN(10, "PCIE30_1L_1_CLKREQ_N"),
	MT7988_TYPE0_PIN(11, "GPIO_P"),
	MT7988_TYPE0_PIN(12, "WATCHDOG"),
	MT7988_TYPE1_PIN(13, "GPIO_RESET"),
	MT7988_TYPE1_PIN(14, "GPIO_WPS"),
	MT7988_TYPE2_PIN(15, "PMIC_I2C_SCL"),
	MT7988_TYPE2_PIN(16, "PMIC_I2C_SDA"),
	MT7988_TYPE2_PIN(17, "I2C_1_SCL"),
	MT7988_TYPE2_PIN(18, "I2C_1_SDA"),
	MT7988_TYPE0_PIN(19, "PCIE30_2L_0_PRESET_N"),
	MT7988_TYPE0_PIN(20, "PCIE30_1L_1_PRESET_N"),
	MT7988_TYPE0_PIN(21, "PWMD1"),
	MT7988_TYPE0_PIN(22, "SPI0_WP"),
	MT7988_TYPE0_PIN(23, "SPI0_HOLD"),
	MT7988_TYPE0_PIN(24, "SPI0_CSB"),
	MT7988_TYPE0_PIN(25, "SPI0_MISO"),
	MT7988_TYPE0_PIN(26, "SPI0_MOSI"),
	MT7988_TYPE0_PIN(27, "SPI0_CLK"),
	MT7988_TYPE0_PIN(28, "SPI1_CSB"),
	MT7988_TYPE0_PIN(29, "SPI1_MISO"),
	MT7988_TYPE0_PIN(30, "SPI1_MOSI"),
	MT7988_TYPE0_PIN(31, "SPI1_CLK"),
	MT7988_TYPE0_PIN(32, "SPI2_CLK"),
	MT7988_TYPE0_PIN(33, "SPI2_MOSI"),
	MT7988_TYPE0_PIN(34, "SPI2_MISO"),
	MT7988_TYPE0_PIN(35, "SPI2_CSB"),
	MT7988_TYPE0_PIN(36, "SPI2_HOLD"),
	MT7988_TYPE0_PIN(37, "SPI2_WP"),
	MT7988_TYPE0_PIN(38, "EMMC_RSTB"),
	MT7988_TYPE0_PIN(39, "EMMC_DSL"),
	MT7988_TYPE0_PIN(40, "EMMC_CK"),
	MT7988_TYPE0_PIN(41, "EMMC_CMD"),
	MT7988_TYPE0_PIN(42, "EMMC_DATA_7"),
	MT7988_TYPE0_PIN(43, "EMMC_DATA_6"),
	MT7988_TYPE0_PIN(44, "EMMC_DATA_5"),
	MT7988_TYPE0_PIN(45, "EMMC_DATA_4"),
	MT7988_TYPE0_PIN(46, "EMMC_DATA_3"),
	MT7988_TYPE0_PIN(47, "EMMC_DATA_2"),
	MT7988_TYPE0_PIN(48, "EMMC_DATA_1"),
	MT7988_TYPE0_PIN(49, "EMMC_DATA_0"),
	MT7988_TYPE0_PIN(50, "PCM_FS_I2S_LRCK"),
	MT7988_TYPE0_PIN(51, "PCM_CLK_I2S_BCLK"),
	MT7988_TYPE0_PIN(52, "PCM_DRX_I2S_DIN"),
	MT7988_TYPE0_PIN(53, "PCM_DTX_I2S_DOUT"),
	MT7988_TYPE0_PIN(54, "PCM_MCK_I2S_MCLK"),
	MT7988_TYPE0_PIN(55, "UART0_RXD"),
	MT7988_TYPE0_PIN(56, "UART0_TXD"),
	MT7988_TYPE0_PIN(57, "PWMD0"),
	MT7988_TYPE0_PIN(58, "JTAG_JTDI"),
	MT7988_TYPE0_PIN(59, "JTAG_JTDO"),
	MT7988_TYPE0_PIN(60, "JTAG_JTMS"),
	MT7988_TYPE0_PIN(61, "JTAG_JTCLK"),
	MT7988_TYPE0_PIN(62, "JTAG_JTRST_N"),
	MT7988_TYPE1_PIN(63, "USB_DRV_VBUS_P1"),
	MT7988_TYPE0_PIN(64, "LED_A"),
	MT7988_TYPE0_PIN(65, "LED_B"),
	MT7988_TYPE0_PIN(66, "LED_C"),
	MT7988_TYPE0_PIN(67, "LED_D"),
	MT7988_TYPE0_PIN(68, "LED_E"),
	MT7988_TYPE0_PIN(69, "GPIO_B"),
	MT7988_TYPE0_PIN(70, "GPIO_C"),
	MT7988_TYPE2_PIN(71, "I2C_2_SCL"),
	MT7988_TYPE2_PIN(72, "I2C_2_SDA"),
	MT7988_TYPE0_PIN(73, "PCIE30_2L_1_PRESET_N"),
	MT7988_TYPE0_PIN(74, "PCIE30_1L_0_PRESET_N"),
	MT7988_TYPE1_PIN(75, "PCIE30_2L_1_WAKE_N"),
	MT7988_TYPE1_PIN(76, "PCIE30_2L_1_CLKREQ_N"),
	MT7988_TYPE1_PIN(77, "PCIE30_1L_0_WAKE_N"),
	MT7988_TYPE1_PIN(78, "PCIE30_1L_0_CLKREQ_N"),
	MT7988_TYPE1_PIN(79, "USB_DRV_VBUS_P0"),
	MT7988_TYPE0_PIN(80, "UART1_RXD"),
	MT7988_TYPE0_PIN(81, "UART1_TXD"),
	MT7988_TYPE0_PIN(82, "UART1_CTS"),
	MT7988_TYPE0_PIN(83, "UART1_RTS"),
};

/* jtag */
static const int mt7988_tops_jtag0_0_pins[] = { 0, 1, 2, 3, 4 };
static const int mt7988_tops_jtag0_0_funcs[] = { 2, 2, 2, 2, 2 };

static const int mt7988_wo0_jtag_pins[] = { 50, 51, 52, 53, 54 };
static const int mt7988_wo0_jtag_funcs[] = { 3, 3, 3, 3, 3 };

static const int mt7988_wo1_jtag_pins[] = { 50, 51, 52, 53, 54 };
static const int mt7988_wo1_jtag_funcs[] = { 4, 4, 4, 4, 4 };

static const int mt7988_wo2_jtag_pins[] = { 50, 51, 52, 53, 54 };
static const int mt7988_wo2_jtag_funcs[] = { 5, 5, 5, 5, 5 };

static const int mt7988_jtag_pins[] = { 58, 59, 60, 61, 62 };
static const int mt7988_jtag_funcs[] = { 1, 1, 1, 1, 1 };

static const int mt7988_tops_jtag0_1_pins[] = { 58, 59, 60, 61, 62 };
static const int mt7988_tops_jtag0_1_funcs[] = { 4, 4, 4, 4, 4 };

/* int_usxgmii */
static const int mt7988_int_usxgmii_pins[] = { 2, 3 };
static const int mt7988_int_usxgmii_funcs[] = { 3, 3 };

/* pwm */
static const int mt7988_pwm0_pins[] = { 57 };
static const int mt7988_pwm0_funcs[] = { 1 };

static const int mt7988_pwm1_pins[] = { 21 };
static const int mt7988_pwm1_funcs[] = { 1 };

static const int mt7988_pwm2_pins[] = { 80 };
static const int mt7988_pwm2_funcs[] = { 2 };

static const int mt7988_pwm3_pins[] = { 81 };
static const int mt7988_pwm3_funcs[] = { 2 };

static const int mt7988_pwm4_pins[] = { 82 };
static const int mt7988_pwm4_funcs[] = { 2 };

static const int mt7988_pwm5_pins[] = { 83 };
static const int mt7988_pwm5_funcs[] = { 2 };

static const int mt7988_pwm6_pins[] = { 69 };
static const int mt7988_pwm6_funcs[] = { 3 };

static const int mt7988_pwm7_pins[] = { 70 };
static const int mt7988_pwm7_funcs[] = { 3 };

/* dfd */
static const int mt7988_dfd_pins[] = { 0, 1, 2, 3, 4 };
static const int mt7988_dfd_funcs[] = { 4, 4, 4, 4, 4 };

/* i2c */
static const int mt7988_xfi_phy0_i2c0_pins[] = { 0, 1 };
static const int mt7988_xfi_phy0_i2c0_funcs[] = { 5, 5 };

static const int mt7988_xfi_phy1_i2c0_pins[] = { 0, 1 };
static const int mt7988_xfi_phy1_i2c0_funcs[] = { 6, 6 };

static const int mt7988_xfi_phy_pll_i2c0_pins[] = { 3, 4 };
static const int mt7988_xfi_phy_pll_i2c0_funcs[] = { 5, 5 };

static const int mt7988_xfi_phy_pll_i2c1_pins[] = { 3, 4 };
static const int mt7988_xfi_phy_pll_i2c1_funcs[] = { 6, 6 };

static const int mt7988_i2c0_0_pins[] = { 5, 6 };
static const int mt7988_i2c0_0_funcs[] = { 2, 2 };

static const int mt7988_i2c1_sfp_pins[] = { 5, 6 };
static const int mt7988_i2c1_sfp_funcs[] = { 4, 4 };

static const int mt7988_xfi_pextp_phy0_i2c_pins[] = { 5, 6 };
static const int mt7988_xfi_pextp_phy0_i2c_funcs[] = { 5, 5 };

static const int mt7988_xfi_pextp_phy1_i2c_pins[] = { 5, 6 };
static const int mt7988_xfi_pextp_phy1_i2c_funcs[] = { 6, 6 };

static const int mt7988_i2c0_1_pins[] = { 15, 16 };
static const int mt7988_i2c0_1_funcs[] = { 1, 1 };

static const int mt7988_u30_phy_i2c0_pins[] = { 15, 16 };
static const int mt7988_u30_phy_i2c0_funcs[] = { 2, 2 };

static const int mt7988_u32_phy_i2c0_pins[] = { 15, 16 };
static const int mt7988_u32_phy_i2c0_funcs[] = { 3, 3 };

static const int mt7988_xfi_phy0_i2c1_pins[] = { 15, 16 };
static const int mt7988_xfi_phy0_i2c1_funcs[] = { 5, 5 };

static const int mt7988_xfi_phy1_i2c1_pins[] = { 15, 16 };
static const int mt7988_xfi_phy1_i2c1_funcs[] = { 6, 6 };

static const int mt7988_xfi_phy_pll_i2c2_pins[] = { 15, 16 };
static const int mt7988_xfi_phy_pll_i2c2_funcs[] = { 7, 7 };

static const int mt7988_i2c1_0_pins[] = { 17, 18 };
static const int mt7988_i2c1_0_funcs[] = { 1, 1 };

static const int mt7988_u30_phy_i2c1_pins[] = { 17, 18 };
static const int mt7988_u30_phy_i2c1_funcs[] = { 2, 2 };

static const int mt7988_u32_phy_i2c1_pins[] = { 17, 18 };
static const int mt7988_u32_phy_i2c1_funcs[] = { 3, 3 };

static const int mt7988_xfi_phy_pll_i2c3_pins[] = { 17, 18 };
static const int mt7988_xfi_phy_pll_i2c3_funcs[] = { 4, 4 };

static const int mt7988_sgmii0_i2c_pins[] = { 17, 18 };
static const int mt7988_sgmii0_i2c_funcs[] = { 5, 5 };

static const int mt7988_sgmii1_i2c_pins[] = { 17, 18 };
static const int mt7988_sgmii1_i2c_funcs[] = { 6, 6 };

static const int mt7988_i2c1_2_pins[] = { 69, 70 };
static const int mt7988_i2c1_2_funcs[] = { 2, 2 };

static const int mt7988_i2c2_0_pins[] = { 69, 70 };
static const int mt7988_i2c2_0_funcs[] = { 4, 4 };

static const int mt7988_i2c2_1_pins[] = { 71, 72 };
static const int mt7988_i2c2_1_funcs[] = { 1, 1 };

/* eth */
static const int mt7988_mdc_mdio0_pins[] = { 5, 6 };
static const int mt7988_mdc_mdio0_funcs[] = { 1, 1 };

static const int mt7988_2p5g_ext_mdio_pins[] = { 28, 29 };
static const int mt7988_2p5g_ext_mdio_funcs[] = { 6, 6 };

static const int mt7988_gbe_ext_mdio_pins[] = { 30, 31 };
static const int mt7988_gbe_ext_mdio_funcs[] = { 6, 6 };

static const int mt7988_mdc_mdio1_pins[] = { 69, 70 };
static const int mt7988_mdc_mdio1_funcs[] = { 1, 1 };

/* pcie */
static const int mt7988_pcie_wake_n0_0_pins[] = { 7 };
static const int mt7988_pcie_wake_n0_0_funcs[] = { 1 };

static const int mt7988_pcie_clk_req_n0_0_pins[] = { 8 };
static const int mt7988_pcie_clk_req_n0_0_funcs[] = { 1 };

static const int mt7988_pcie_wake_n3_0_pins[] = { 9 };
static const int mt7988_pcie_wake_n3_0_funcs[] = { 1 };

static const int mt7988_pcie_clk_req_n3_pins[] = { 10 };
static const int mt7988_pcie_clk_req_n3_funcs[] = { 1 };

static const int mt7988_pcie_clk_req_n0_1_pins[] = { 10 };
static const int mt7988_pcie_clk_req_n0_1_funcs[] = { 2 };

static const int mt7988_pcie_p0_phy_i2c_pins[] = { 7, 8 };
static const int mt7988_pcie_p0_phy_i2c_funcs[] = { 3, 3 };

static const int mt7988_pcie_p1_phy_i2c_pins[] = { 7, 8 };
static const int mt7988_pcie_p1_phy_i2c_funcs[] = { 4, 4 };

static const int mt7988_pcie_p3_phy_i2c_pins[] = { 9, 10 };
static const int mt7988_pcie_p3_phy_i2c_funcs[] = { 4, 4 };

static const int mt7988_pcie_p2_phy_i2c_pins[] = { 7, 8 };
static const int mt7988_pcie_p2_phy_i2c_funcs[] = { 5, 5 };

static const int mt7988_ckm_phy_i2c_pins[] = { 9, 10 };
static const int mt7988_ckm_phy_i2c_funcs[] = { 5, 5 };

static const int mt7988_pcie_wake_n0_1_pins[] = { 13 };
static const int mt7988_pcie_wake_n0_1_funcs[] = { 2 };

static const int mt7988_pcie_wake_n3_1_pins[] = { 14 };
static const int mt7988_pcie_wake_n3_1_funcs[] = { 2 };

static const int mt7988_pcie_2l_0_pereset_pins[] = { 19 };
static const int mt7988_pcie_2l_0_pereset_funcs[] = { 1 };

static const int mt7988_pcie_1l_1_pereset_pins[] = { 20 };
static const int mt7988_pcie_1l_1_pereset_funcs[] = { 1 };

static const int mt7988_pcie_clk_req_n2_1_pins[] = { 63 };
static const int mt7988_pcie_clk_req_n2_1_funcs[] = { 2 };

static const int mt7988_pcie_2l_1_pereset_pins[] = { 73 };
static const int mt7988_pcie_2l_1_pereset_funcs[] = { 1 };

static const int mt7988_pcie_1l_0_pereset_pins[] = { 74 };
static const int mt7988_pcie_1l_0_pereset_funcs[] = { 1 };

static const int mt7988_pcie_wake_n1_0_pins[] = { 75 };
static const int mt7988_pcie_wake_n1_0_funcs[] = { 1 };

static const int mt7988_pcie_clk_req_n1_pins[] = { 76 };
static const int mt7988_pcie_clk_req_n1_funcs[] = { 1 };

static const int mt7988_pcie_wake_n2_0_pins[] = { 77 };
static const int mt7988_pcie_wake_n2_0_funcs[] = { 1 };

static const int mt7988_pcie_clk_req_n2_0_pins[] = { 78 };
static const int mt7988_pcie_clk_req_n2_0_funcs[] = { 1 };

static const int mt7988_pcie_wake_n2_1_pins[] = { 79 };
static const int mt7988_pcie_wake_n2_1_funcs[] = { 2 };

/* pmic */
static const int mt7988_pmic_pins[] = { 11 };
static const int mt7988_pmic_funcs[] = { 1 };

/* watchdog */
static const int mt7988_watchdog_pins[] = { 12 };
static const int mt7988_watchdog_funcs[] = { 1 };

/* spi */
static const int mt7988_spi0_wp_hold_pins[] = { 22, 23 };
static const int mt7988_spi0_wp_hold_funcs[] = { 1, 1 };

static const int mt7988_spi0_pins[] = { 24, 25, 26, 27 };
static const int mt7988_spi0_funcs[] = { 1, 1, 1, 1 };

static const int mt7988_spi1_pins[] = { 28, 29, 30, 31 };
static const int mt7988_spi1_funcs[] = { 1, 1, 1, 1 };

static const int mt7988_spi2_pins[] = { 32, 33, 34, 35 };
static const int mt7988_spi2_funcs[] = { 1, 1, 1, 1 };

static const int mt7988_spi2_wp_hold_pins[] = { 36, 37 };
static const int mt7988_spi2_wp_hold_funcs[] = { 1, 1 };

/* flash */
static const int mt7988_snfi_pins[] = { 22, 23, 24, 25, 26, 27 };
static const int mt7988_snfi_funcs[] = { 2, 2, 2, 2, 2, 2 };

static const int mt7988_emmc_45_pins[] = {
	21, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37 };
static const int mt7988_emmc_45_funcs[] = { 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5 };

static const int mt7988_emmc_51_pins[] = {
	38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49 };
static const int mt7988_emmc_51_funcs[] = {
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 };

/* uart */
static const int mt7988_uart2_pins[] = { 0, 1, 2, 3 };
static const int mt7988_uart2_funcs[] = { 1, 1, 1, 1 };

static const int mt7988_tops_uart0_0_pins[] = { 22, 23 };
static const int mt7988_tops_uart0_0_funcs[] = { 3, 3 };

static const int mt7988_uart2_0_pins[] = { 28, 29, 30, 31 };
static const int mt7988_uart2_0_funcs[] = { 2, 2, 2, 2 };

static const int mt7988_uart1_0_pins[] = { 32, 33, 34, 35 };
static const int mt7988_uart1_0_funcs[] = { 2, 2, 2, 2 };

static const int mt7988_uart2_1_pins[] = { 32, 33, 34, 35 };
static const int mt7988_uart2_1_funcs[] = { 3, 3, 3, 3 };

static const int mt7988_net_wo0_uart_txd_0_pins[] = { 28 };
static const int mt7988_net_wo0_uart_txd_0_funcs[] = { 3 };

static const int mt7988_net_wo1_uart_txd_0_pins[] = { 29 };
static const int mt7988_net_wo1_uart_txd_0_funcs[] = { 3 };

static const int mt7988_net_wo2_uart_txd_0_pins[] = { 30 };
static const int mt7988_net_wo2_uart_txd_0_funcs[] = { 3 };

static const int mt7988_tops_uart1_0_pins[] = { 28, 29 };
static const int mt7988_tops_uart1_0_funcs[] = { 4, 4 };

static const int mt7988_tops_uart0_1_pins[] = { 30, 31 };
static const int mt7988_tops_uart0_1_funcs[] = { 4, 4 };

static const int mt7988_tops_uart1_1_pins[] = { 36, 37 };
static const int mt7988_tops_uart1_1_funcs[] = { 3, 3 };

static const int mt7988_uart0_pins[] = { 55, 56 };
static const int mt7988_uart0_funcs[] = { 1, 1 };

static const int mt7988_tops_uart0_2_pins[] = { 55, 56 };
static const int mt7988_tops_uart0_2_funcs[] = { 2, 2 };

static const int mt7988_uart2_2_pins[] = { 50, 51, 52, 53 };
static const int mt7988_uart2_2_funcs[] = { 2, 2, 2, 2 };

static const int mt7988_uart1_1_pins[] = { 58, 59, 60, 61 };
static const int mt7988_uart1_1_funcs[] = { 2, 2, 2, 2 };

static const int mt7988_uart2_3_pins[] = { 58, 59, 60, 61 };
static const int mt7988_uart2_3_funcs[] = { 3, 3, 3, 3 };

static const int mt7988_uart1_2_pins[] = { 80, 81, 82, 83 };
static const int mt7988_uart1_2_funcs[] = { 1, 1, 1, 1 };

static const int mt7988_tops_uart1_2_pins[] = { 80, 81 };
static const int mt7988_tops_uart1_2_funcs[] = { 4, 4, };

static const int mt7988_net_wo0_uart_txd_1_pins[] = { 80 };
static const int mt7988_net_wo0_uart_txd_1_funcs[] = { 3 };

static const int mt7988_net_wo1_uart_txd_1_pins[] = { 81 };
static const int mt7988_net_wo1_uart_txd_1_funcs[] = { 3 };

static const int mt7988_net_wo2_uart_txd_1_pins[] = { 82 };
static const int mt7988_net_wo2_uart_txd_1_funcs[] = { 3 };

/* udi */
static const int mt7988_udi_pins[] = { 32, 33, 34, 35, 36 };
static const int mt7988_udi_funcs[] = { 4, 4, 4, 4, 4 };

/* pcm */
static const int mt7988_pcm_pins[] = { 50, 51, 52, 53, 54 };
static const int mt7988_pcm_funcs[] = { 1, 1, 1, 1, 1 };

/* led */
static const int mt7988_gbe_led1_pins[] = { 58, 59, 60, 61 };
static const int mt7988_gbe_led1_funcs[] = { 6, 6, 6, 6 };

static const int mt7988_2p5gbe_led1_pins[] = { 62 };
static const int mt7988_2p5gbe_led1_funcs[] = { 6 };

static const int mt7988_gbe_led0_pins[] = { 64, 65, 66, 67 };
static const int mt7988_gbe_led0_funcs[] = { 1, 1, 1, 1 };

static const int mt7988_2p5gbe_led0_pins[] = { 68 };
static const int mt7988_2p5gbe_led0_funcs[] = { 1 };

/* usb */
static const int mt7988_drv_vbus_p1_pins[] = { 63 };
static const int mt7988_drv_vbus_p1_funcs[] = { 1 };

static const int mt7988_drv_vbus_pins[] = { 79 };
static const int mt7988_drv_vbus_funcs[] = { 1 };

static const struct mtk_group_desc mt7988_groups[] = {
	PINCTRL_PIN_GROUP("uart2", mt7988_uart2),
	PINCTRL_PIN_GROUP("tops_jtag0_0", mt7988_tops_jtag0_0),
	PINCTRL_PIN_GROUP("int_usxgmii", mt7988_int_usxgmii),
	PINCTRL_PIN_GROUP("dfd", mt7988_dfd),
	PINCTRL_PIN_GROUP("xfi_phy0_i2c0", mt7988_xfi_phy0_i2c0),
	PINCTRL_PIN_GROUP("xfi_phy1_i2c0", mt7988_xfi_phy1_i2c0),
	PINCTRL_PIN_GROUP("xfi_phy_pll_i2c0", mt7988_xfi_phy_pll_i2c0),
	PINCTRL_PIN_GROUP("xfi_phy_pll_i2c1", mt7988_xfi_phy_pll_i2c1),
	PINCTRL_PIN_GROUP("i2c0_0", mt7988_i2c0_0),
	PINCTRL_PIN_GROUP("i2c1_sfp", mt7988_i2c1_sfp),
	PINCTRL_PIN_GROUP("xfi_pextp_phy0_i2c", mt7988_xfi_pextp_phy0_i2c),
	PINCTRL_PIN_GROUP("xfi_pextp_phy1_i2c", mt7988_xfi_pextp_phy1_i2c),
	PINCTRL_PIN_GROUP("mdc_mdio0", mt7988_mdc_mdio0),
	PINCTRL_PIN_GROUP("pcie_wake_n0_0", mt7988_pcie_wake_n0_0),
	PINCTRL_PIN_GROUP("pcie_clk_req_n0_0", mt7988_pcie_clk_req_n0_0),
	PINCTRL_PIN_GROUP("pcie_wake_n3_0", mt7988_pcie_wake_n3_0),
	PINCTRL_PIN_GROUP("pcie_clk_req_n3", mt7988_pcie_clk_req_n3),
	PINCTRL_PIN_GROUP("pcie_clk_req_n0_1", mt7988_pcie_clk_req_n0_1),
	PINCTRL_PIN_GROUP("pcie_p0_phy_i2c", mt7988_pcie_p0_phy_i2c),
	PINCTRL_PIN_GROUP("pcie_p1_phy_i2c", mt7988_pcie_p1_phy_i2c),
	PINCTRL_PIN_GROUP("pcie_p2_phy_i2c", mt7988_pcie_p2_phy_i2c),
	PINCTRL_PIN_GROUP("pcie_p3_phy_i2c", mt7988_pcie_p3_phy_i2c),
	PINCTRL_PIN_GROUP("ckm_phy_i2c", mt7988_ckm_phy_i2c),
	PINCTRL_PIN_GROUP("pcie_pmic", mt7988_pmic),
	PINCTRL_PIN_GROUP("watchdog", mt7988_watchdog),
	PINCTRL_PIN_GROUP("pcie_wake_n0_1", mt7988_pcie_wake_n0_1),
	PINCTRL_PIN_GROUP("pcie_wake_n3_1", mt7988_pcie_wake_n3_1),
	PINCTRL_PIN_GROUP("i2c0_1", mt7988_i2c0_1),
	PINCTRL_PIN_GROUP("u30_phy_i2c0", mt7988_u30_phy_i2c0),
	PINCTRL_PIN_GROUP("u32_phy_i2c0", mt7988_u32_phy_i2c0),
	PINCTRL_PIN_GROUP("xfi_phy0_i2c1", mt7988_xfi_phy0_i2c1),
	PINCTRL_PIN_GROUP("xfi_phy1_i2c1", mt7988_xfi_phy1_i2c1),
	PINCTRL_PIN_GROUP("xfi_phy_pll_i2c2", mt7988_xfi_phy_pll_i2c2),
	PINCTRL_PIN_GROUP("i2c1_0", mt7988_i2c1_0),
	PINCTRL_PIN_GROUP("u30_phy_i2c1", mt7988_u30_phy_i2c1),
	PINCTRL_PIN_GROUP("u32_phy_i2c1", mt7988_u32_phy_i2c1),
	PINCTRL_PIN_GROUP("xfi_phy_pll_i2c3", mt7988_xfi_phy_pll_i2c3),
	PINCTRL_PIN_GROUP("sgmii0_i2c", mt7988_sgmii0_i2c),
	PINCTRL_PIN_GROUP("sgmii1_i2c", mt7988_sgmii1_i2c),
	PINCTRL_PIN_GROUP("pcie_2l_0_pereset", mt7988_pcie_2l_0_pereset),
	PINCTRL_PIN_GROUP("pcie_1l_1_pereset", mt7988_pcie_1l_1_pereset),
	PINCTRL_PIN_GROUP("pwm1", mt7988_pwm1),
	PINCTRL_PIN_GROUP("spi0_wp_hold", mt7988_spi0_wp_hold),
	PINCTRL_PIN_GROUP("spi0", mt7988_spi0),
	PINCTRL_PIN_GROUP("spi1", mt7988_spi1),
	PINCTRL_PIN_GROUP("spi2", mt7988_spi2),
	PINCTRL_PIN_GROUP("spi2_wp_hold", mt7988_spi2_wp_hold),
	PINCTRL_PIN_GROUP("snfi", mt7988_snfi),
	PINCTRL_PIN_GROUP("tops_uart0_0", mt7988_tops_uart0_0),
	PINCTRL_PIN_GROUP("uart2_0", mt7988_uart2_0),
	PINCTRL_PIN_GROUP("uart1_0", mt7988_uart1_0),
	PINCTRL_PIN_GROUP("uart2_1", mt7988_uart2_1),
	PINCTRL_PIN_GROUP("net_wo0_uart_txd_0", mt7988_net_wo0_uart_txd_0),
	PINCTRL_PIN_GROUP("net_wo1_uart_txd_0", mt7988_net_wo1_uart_txd_0),
	PINCTRL_PIN_GROUP("net_wo2_uart_txd_0", mt7988_net_wo2_uart_txd_0),
	PINCTRL_PIN_GROUP("tops_uart0_0", mt7988_tops_uart1_0),
	PINCTRL_PIN_GROUP("tops_uart0_1", mt7988_tops_uart0_1),
	PINCTRL_PIN_GROUP("tops_uart1_1", mt7988_tops_uart1_1),
	PINCTRL_PIN_GROUP("udi", mt7988_udi),
	PINCTRL_PIN_GROUP("emmc_45", mt7988_emmc_45),
	PINCTRL_PIN_GROUP("emmc_51", mt7988_emmc_51),
	PINCTRL_PIN_GROUP("2p5g_ext_mdio", mt7988_2p5g_ext_mdio),
	PINCTRL_PIN_GROUP("gbe_ext_mdio", mt7988_gbe_ext_mdio),
	PINCTRL_PIN_GROUP("pcm", mt7988_pcm),
	PINCTRL_PIN_GROUP("uart0", mt7988_uart0),
	PINCTRL_PIN_GROUP("tops_uart0_2", mt7988_tops_uart0_2),
	PINCTRL_PIN_GROUP("uart2_2", mt7988_uart2_2),
	PINCTRL_PIN_GROUP("wo0_jtag", mt7988_wo0_jtag),
	PINCTRL_PIN_GROUP("wo1_jtag", mt7988_wo1_jtag),
	PINCTRL_PIN_GROUP("wo2_jtag", mt7988_wo2_jtag),
	PINCTRL_PIN_GROUP("pwm0", mt7988_pwm0),
	PINCTRL_PIN_GROUP("jtag", mt7988_jtag),
	PINCTRL_PIN_GROUP("tops_jtag0_1", mt7988_tops_jtag0_1),
	PINCTRL_PIN_GROUP("uart2_3", mt7988_uart2_3),
	PINCTRL_PIN_GROUP("uart1_1", mt7988_uart1_1),
	PINCTRL_PIN_GROUP("gbe_led1", mt7988_gbe_led1),
	PINCTRL_PIN_GROUP("2p5gbe_led1", mt7988_2p5gbe_led1),
	PINCTRL_PIN_GROUP("gbe_led0", mt7988_gbe_led0),
	PINCTRL_PIN_GROUP("2p5gbe_led0", mt7988_2p5gbe_led0),
	PINCTRL_PIN_GROUP("drv_vbus_p1", mt7988_drv_vbus_p1),
	PINCTRL_PIN_GROUP("pcie_clk_req_n2_1", mt7988_pcie_clk_req_n2_1),
	PINCTRL_PIN_GROUP("mdc_mdio1", mt7988_mdc_mdio1),
	PINCTRL_PIN_GROUP("i2c1_2", mt7988_i2c1_2),
	PINCTRL_PIN_GROUP("pwm6", mt7988_pwm6),
	PINCTRL_PIN_GROUP("pwm7", mt7988_pwm7),
	PINCTRL_PIN_GROUP("i2c2_0", mt7988_i2c2_0),
	PINCTRL_PIN_GROUP("i2c2_1", mt7988_i2c2_1),
	PINCTRL_PIN_GROUP("pcie_2l_1_pereset", mt7988_pcie_2l_1_pereset),
	PINCTRL_PIN_GROUP("pcie_1l_0_pereset", mt7988_pcie_1l_0_pereset),
	PINCTRL_PIN_GROUP("pcie_wake_n1_0", mt7988_pcie_wake_n1_0),
	PINCTRL_PIN_GROUP("pcie_clk_req_n1", mt7988_pcie_clk_req_n1),
	PINCTRL_PIN_GROUP("pcie_wake_n2_0", mt7988_pcie_wake_n2_0),
	PINCTRL_PIN_GROUP("pcie_clk_req_n2_0", mt7988_pcie_clk_req_n2_0),
	PINCTRL_PIN_GROUP("drv_vbus", mt7988_drv_vbus),
	PINCTRL_PIN_GROUP("pcie_wake_n2_1", mt7988_pcie_wake_n2_1),
	PINCTRL_PIN_GROUP("uart1_2", mt7988_uart1_2),
	PINCTRL_PIN_GROUP("pwm2", mt7988_pwm2),
	PINCTRL_PIN_GROUP("pwm3", mt7988_pwm3),
	PINCTRL_PIN_GROUP("pwm4", mt7988_pwm4),
	PINCTRL_PIN_GROUP("pwm5", mt7988_pwm5),
	PINCTRL_PIN_GROUP("net_wo0_uart_txd_0", mt7988_net_wo0_uart_txd_0),
	PINCTRL_PIN_GROUP("net_wo1_uart_txd_0", mt7988_net_wo1_uart_txd_0),
	PINCTRL_PIN_GROUP("net_wo2_uart_txd_0", mt7988_net_wo2_uart_txd_0),
	PINCTRL_PIN_GROUP("tops_uart1_2", mt7988_tops_uart1_2),
	PINCTRL_PIN_GROUP("net_wo0_uart_txd_1", mt7988_net_wo0_uart_txd_1),
	PINCTRL_PIN_GROUP("net_wo1_uart_txd_1", mt7988_net_wo1_uart_txd_1),
	PINCTRL_PIN_GROUP("net_wo2_uart_txd_1", mt7988_net_wo2_uart_txd_1),
};

static const struct mtk_io_type_desc mt7988_io_type_desc[] = {
	[IO_TYPE_GRP0] = {
		.name = "18OD33",
		.bias_set = mtk_pinconf_bias_set_pupd_r1_r0,
		.drive_set = mtk_pinconf_drive_set_v1,
		.input_enable = mtk_pinconf_input_enable_v1,
	},
	[IO_TYPE_GRP1] = {
		.name = "18A01",
		.bias_set = mtk_pinconf_bias_set_pu_pd,
		.drive_set = mtk_pinconf_drive_set_v1,
		.input_enable = mtk_pinconf_input_enable_v1,
	},
	[IO_TYPE_GRP2] = {
		.name = "I2C",
		.input_enable = mtk_pinconf_input_enable_v1,
	},
};

/* Joint those groups owning the same capability in user point of view which
 * allows that people tend to use through the device tree.
 */
static const char *const mt7988_jtag_groups[] = { "tops_jtag0_0", "wo0_jtag",
	"wo1_jtag", "wo2_jtag", "jtag", "tops_jtag0_1", };
static const char *const mt7988_int_usxgmii_groups[] = { "int_usxgmii", };
static const char *const mt7988_pwm_groups[] = { "pwm0", "pwm1", "pwm2", "pwm3",
	"pwm4", "pwm5", "pwm6", "pwm7" };
static const char *const mt7988_dfd_groups[] = { "dfd", };
static const char *const mt7988_i2c_groups[] = { "xfi_phy0_i2c0",
	"xfi_phy1_i2c0", "xfi_phy_pll_i2c0", "xfi_phy_pll_i2c1", "i2c0_0",
	"i2c1_sfp", "xfi_pextp_phy0_i2c", "xfi_pextp_phy1_i2c", "i2c0_1",
	"u30_phy_i2c0", "u32_phy_i2c0", "xfi_phy0_i2c1", "xfi_phy1_i2c1",
	"xfi_phy_pll_i2c2", "i2c1_0", "u30_phy_i2c1", "u32_phy_i2c1",
	"xfi_phy_pll_i2c3", "sgmii0_i2c", "sgmii1_i2c", "i2c1_2", "i2c2_0",
	"i2c2_1", };
static const char *const mt7988_ethernet_groups[] = { "mdc_mdio0",
	"2p5g_ext_mdio", "gbe_ext_mdio", "mdc_mdio1", };
static const char *const mt7988_pcie_groups[] = { "pcie_wake_n0_0",
	"pcie_clk_req_n0_0", "pcie_wake_n3_0", "pcie_clk_req_n3",
	"pcie_p0_phy_i2c", "pcie_p1_phy_i2c", "pcie_p3_phy_i2",
	"pcie_p2_phy_i2c", "ckm_phy_i2c", "pcie_wake_n0_1", "pcie_wake_n3_1",
	"pcie_2l_0_pereset", "pcie_1l_1_pereset", "pcie_clk_req_n2_1",
	"pcie_2l_1_perese", "pcie_1l_0_pereset", "pcie_wake_n1_0",
	"cie_clk_req_n1", "pcie_wake_n2_0", "pcie_wake_n2_1", };
static const char *const mt7988_pmic_groups[] = { "pmic", };
static const char *const mt7988_wdt_groups[] = { "watchdog", };
static const char *const mt7988_spi_groups[] = { "spi0", "spi0_wp_hold",
	"spi1", "spi2", "spi2_wp_hold", };
static const char *const mt7988_flash_groups[] = { "emmc_45", "snfi",
	"emmc_51" };
static const char *const mt7988_uart_groups[] = { "uart2", "tops_uart0_0",
	"uart2_0", "uart1_0", "uart2_1",
	"net_wo0_uart_txd_0", "net_wo1_uart_txd_0", "net_wo2_uart_txd_0",
	"tops_uart1_0", "ops_uart0_1", "ops_uart1_1",
	"uart0", "tops_uart0_2", "uart1_1",
	"uart2_3", "uart1_2", "tops_uart1_2",
	"net_wo0_uart_txd_1", "net_wo1_uart_txd_1", "net_wo2_uart_txd_1", };
static const char *const mt7988_udi_groups[] = { "udi", };
static const char *const mt7988_pcm_groups[] = { "pcm", };
static const char *const mt7988_led_groups[] = { "gbe_led1", "2p5gbe_led1",
	"gbe_led0", "2p5gbe_led0", "wf5g_led0", "wf5g_led1", };
static const char *const mt7988_usb_groups[] = { "drv_vbus", "drv_vbus_p1", };

static const struct mtk_function_desc mt7988_functions[] = {
	{"jtag", mt7988_jtag_groups, ARRAY_SIZE(mt7988_jtag_groups)},
	{"int_usxgmii", mt7988_int_usxgmii_groups,
			ARRAY_SIZE(mt7988_int_usxgmii_groups)},
	{"pwm", mt7988_pwm_groups, ARRAY_SIZE(mt7988_pwm_groups)},
	{"dfd", mt7988_dfd_groups, ARRAY_SIZE(mt7988_dfd_groups)},
	{"i2c", mt7988_i2c_groups, ARRAY_SIZE(mt7988_i2c_groups)},
	{"eth", mt7988_ethernet_groups, ARRAY_SIZE(mt7988_ethernet_groups)},
	{"pcie", mt7988_pcie_groups, ARRAY_SIZE(mt7988_pcie_groups)},
	{"pmic", mt7988_pmic_groups, ARRAY_SIZE(mt7988_pmic_groups)},
	{"watchdog", mt7988_wdt_groups, ARRAY_SIZE(mt7988_wdt_groups)},
	{"spi", mt7988_spi_groups, ARRAY_SIZE(mt7988_spi_groups)},
	{"flash", mt7988_flash_groups, ARRAY_SIZE(mt7988_flash_groups)},
	{"uart", mt7988_uart_groups, ARRAY_SIZE(mt7988_uart_groups)},
	{"udi", mt7988_udi_groups, ARRAY_SIZE(mt7988_udi_groups)},
	{"pcm", mt7988_pcm_groups, ARRAY_SIZE(mt7988_pcm_groups)},
	{"usb", mt7988_usb_groups, ARRAY_SIZE(mt7988_usb_groups)},
	{"led", mt7988_led_groups, ARRAY_SIZE(mt7988_led_groups)},
};

static const char *const mt7988_pinctrl_register_base_names[] = {
	"gpio", "iocfg_tr", "iocfg_br", "iocfg_rb", "iocfg_lb", "iocfg_tl",
};

static const struct mtk_pinctrl_soc mt7988_data = {
	.name = "mt7988_pinctrl",
	.reg_cal = mt7988_reg_cals,
	.pins = mt7988_pins,
	.npins = ARRAY_SIZE(mt7988_pins),
	.grps = mt7988_groups,
	.ngrps = ARRAY_SIZE(mt7988_groups),
	.funcs = mt7988_functions,
	.nfuncs = ARRAY_SIZE(mt7988_functions),
	.io_type = mt7988_io_type_desc,
	.ntype = ARRAY_SIZE(mt7988_io_type_desc),
	.gpio_mode = 0,
	.base_names = mt7988_pinctrl_register_base_names,
	.nbase_names = ARRAY_SIZE(mt7988_pinctrl_register_base_names),
	.base_calc = 1,
};

static int mtk_pinctrl_mt7988_probe(struct udevice *dev)
{
	return mtk_pinctrl_common_probe(dev, &mt7988_data);
}

static const struct udevice_id mt7988_pctrl_match[] = {
	{.compatible = "mediatek,mt7988-pinctrl"},
	{ /* sentinel */ }
};

U_BOOT_DRIVER(mt7988_pinctrl) = {
	.name = "mt7988_pinctrl",
	.id = UCLASS_PINCTRL,
	.of_match = mt7988_pctrl_match,
	.ops = &mtk_pinctrl_ops,
	.bind = mtk_pinctrl_common_bind,
	.probe = mtk_pinctrl_mt7988_probe,
	.priv_auto = sizeof(struct mtk_pinctrl_priv),
};
