// SPDX-License-Identifier: GPL-2.0-or-later

/*
 * Dummy RSA OpenSSL engine to test whether engines work with mkimage
 *
 * OpenSSL can call it with 'dummy-rsa'. The only supported key_id is "dev".
 */

#define OPENSSL_API_COMPAT 0x10101000L

#include <openssl/engine.h>

#define OPENSSL_SUPPRESS_DEPRECATED

static const char *engine_dummy_rsa_id = "dummy-rsa-engine";
static const char *engine_dummy_rsa_name = "Dummy RSA engine";

/* RSA4096 private key */
static const char n[] =
"\x00\xba\x71\x4a\x4a\xe4\xff\x09\xec\x4f\x9f\x94\xec\x18\x14"
"\x8d\xaf\x87\x8a\x90\xda\x63\x5b\x0e\xf3\x5f\x2c\x6d\x03\x60"
"\xc6\xcc\xb9\x6b\xd6\x8f\x07\x79\x8f\xcf\x14\xb8\xf0\x86\x76"
"\x9b\x4b\x50\xbf\x50\x1a\xc0\x34\x66\xb7\x9e\xc0\x0d\xf3\x06"
"\x1d\xa1\x01\xe8\xb4\xaf\x28\x9e\x60\x14\xaa\xe9\xec\xfd\x90"
"\x6e\xa9\x01\x87\x08\xeb\xe7\x3d\x54\x2a\xe8\x8c\x7f\x53\xbf"
"\xec\x3f\x50\x4b\x4d\x41\x4b\x27\xe3\x48\xf9\x73\xc9\x28\x02"
"\xa8\xb3\x12\xa1\xa9\xc1\x38\x4c\xfa\x09\xbe\x7e\xd5\x81\x54"
"\x24\x07\x0e\xc7\x08\xf4\x95\xda\x73\x85\x7f\xeb\xd3\x84\x39"
"\xe8\x1f\xf0\xd2\x38\x16\x80\xbf\x11\x0a\x8b\x0d\x53\x71\x95"
"\x56\x92\xc3\x11\x42\xf4\x04\xc4\x12\xe3\xbd\xfb\xea\xdd\x68"
"\x78\xa2\x72\x61\xa7\xb7\x6e\xd4\x3a\xc8\x0c\xf5\x63\xbe\x81"
"\x9a\x64\x06\x08\x9c\x2d\x4a\x74\xe6\xa1\x72\x98\x2c\x12\x3e"
"\xc8\x8c\xe8\x42\xd3\xf5\x06\x12\xc4\x03\x14\x8b\x9b\xba\x81"
"\x7d\x95\xe5\xde\x38\xe2\x54\xa2\x71\xa6\x99\xda\x74\x50\x5f"
"\x33\x81\xaa\x7b\x0d\x29\x09\x2c\x39\xb5\x76\x32\x22\x7f\xfe"
"\x3a\xf7\xfc\xcf\x37\x4c\x4d\xb7\x78\x9b\xa7\xea\x50\x02\xbe"
"\xef\xf9\x1b\xfb\x09\xcc\x9f\x9a\xab\x30\x5d\xa4\x7c\x75\x0c"
"\x81\x98\x2a\x44\x14\xe6\x30\x3b\x9f\xf1\x6b\x1c\xd0\x16\x55"
"\xdc\x83\x84\xb6\x1f\x68\xb3\x99\x2a\xae\xc8\xfe\x97\x0e\xce"
"\xc8\xd8\x14\x08\xd5\x6c\xf9\xdb\x55\x7a\xae\x8e\xe6\x23\xe5"
"\x85\xec\x16\xdb\x48\xa3\xe3\xd7\x4d\x1c\xd8\x58\x1b\x04\x70"
"\x1a\x23\xab\x13\xa1\x13\x0f\x12\xa5\x03\xa8\x79\x56\x20\xbe"
"\x4b\x0a\xaf\x0d\xee\xe5\x10\xce\xed\x7c\x64\xa2\x03\x11\xbb"
"\x23\xbf\x0e\xe0\x5f\x9b\x47\x43\xbc\x37\xf7\x02\x79\x5b\x06"
"\x30\xac\x1c\x7a\x09\x02\xeb\x8e\x50\xa8\x9d\x18\xc9\x08\x2b"
"\x7e\xe5\x47\xa3\x7a\x35\xc7\x59\xe2\x0d\xda\x49\x7b\xe3\x97"
"\xbf\x39\xfe\x30\xb3\x40\x19\x7d\x1e\x7a\xeb\x19\x05\x79\xac"
"\xb1\xe7\x3d\x84\x24\x34\x05\xeb\x5b\xe6\xd7\x8a\x5e\x26\xe0"
"\xb0\x74\xed\xed\x3f\xe1\xa5\x2b\x57\xc0\x3f\xe5\x23\x28\x97"
"\x35\xa9\x7d\x28\xde\x16\xe2\xe5\x89\x9c\xc1\x94\x03\x91\x36"
"\x6b\x5f\x2a\x64\xfe\x17\x55\xab\x34\xd9\xf3\x51\xad\x75\x89"
"\x12\x9e\xf4\x90\x3b\x5f\xe7\x41\xb4\x2f\xe7\x6f\x10\x76\x96"
"\x20\x70\xce\x5f\x0a\x75\x63\x59\x38\x00\x0f\xe7\x34\x1d\x70"
"\x94\x05\x31";

static const char e[] = "\x01\x00\x01";

static const char d[] =
"\x2e\xad\xfb\xbc\x59\xae\x53\x35\x33\xd0\x50\x30\x76\x6c\xfa"
"\xf6\x76\x38\xa6\xc0\xce\xfc\x76\xf7\x4f\x1e\x67\xe2\xdf\x21"
"\x97\x13\x5b\xa1\x1a\x29\x74\x71\xa1\x96\xde\x20\xf6\x81\x8e"
"\xab\x22\x39\xec\x1b\xee\x80\x90\x31\x2c\x11\x88\xcc\x8e\x7c"
"\xef\x99\x73\x42\x7d\xd2\x6d\x28\xc0\x33\xf4\xa2\xad\xef\xb2"
"\x0d\x25\x81\x42\x26\x12\x3c\xe4\x2c\x64\x11\xfd\x35\x22\x49"
"\xcb\xa6\x56\x5c\x2e\xdb\x5a\xce\xc8\xb0\x10\x21\xce\x9f\x2f"
"\xce\xb9\xfc\xf8\xec\x14\x25\x0d\xbb\x4f\xd3\x20\xb0\xa3\x38"
"\xeb\xfd\x72\xae\xd6\xd2\x08\x22\x41\x4c\x00\x66\xf2\x65\xaf"
"\x2d\x04\x16\x16\x0d\xe8\x49\x2e\x42\x96\x03\x0d\x9f\xd4\x14"
"\x9b\x65\x34\x96\xaf\x52\xdc\x26\xa0\x97\xaa\x11\xa9\x42\xa5"
"\x65\x82\xbe\xd9\x87\x8f\x3b\x9a\xc6\x08\x9c\x8d\xcf\x1e\x52"
"\xe1\xf5\x32\xc5\xab\x7f\x47\x5a\x91\x14\x88\x6e\x0c\x59\x64"
"\xcc\x06\xc0\xe8\xa1\xa1\xd6\x23\xf6\x63\x77\xfa\xd3\x0c\xe5"
"\xbd\x18\x92\xf5\x6a\x11\x67\xa4\x8d\xe2\x5a\x74\x21\xc5\x5c"
"\x37\x7c\x50\x17\xc0\xec\xf7\x82\x31\x61\x38\xf7\x33\x55\x9b"
"\x3d\x08\xb2\x76\xf5\x67\x45\xe6\xf0\x0d\xf0\x17\xfd\x40\x02"
"\x03\xce\x82\xc4\xa5\xa9\xcb\x8b\x9b\x68\x6a\x27\xed\x3a\xb7"
"\xd2\x60\x93\x48\x55\x8c\x87\xc9\x8c\xbd\x97\x24\xd2\x2f\xd1"
"\xc2\x7c\xec\xa7\x4d\x67\x5d\xd4\xfd\xaf\x91\x15\xdd\x57\xcb"
"\x17\xea\xcf\xfc\x84\x19\xd6\x27\x08\xa3\xef\xdc\xe4\x9b\xf6"
"\xea\x72\x37\xb0\xc7\xbc\xe0\xc6\x39\xf8\x89\x1b\xde\x84\xad"
"\xb7\x4f\xf0\xef\x87\x0c\xfe\x5d\x9b\xfd\xee\x6a\x68\xdb\x1f"
"\xc7\x9b\x23\x8f\x1a\xf1\xe8\x3f\x17\xd5\x58\x5f\x0b\x8c\x92"
"\xf4\xc7\x5f\x3c\x71\xa7\xac\xdd\xa3\x3a\x5f\x4f\xc0\xf1\x4c"
"\x8f\x3f\x63\x93\x27\x1b\xbe\xc9\xc1\x5f\x04\xf9\xff\x0f\x36"
"\x62\x6c\x3b\x65\xb3\xa8\xb4\x78\xa8\xab\xae\x3e\xf5\x61\x67"
"\xc1\x9f\xcf\x41\x19\xdc\x21\x7d\x83\xfb\x1b\xcc\x92\x6e\xf8"
"\x70\xcb\xb4\xb2\xc3\x1e\xbe\xaf\x91\xf8\xc8\x32\x17\xad\x82"
"\x62\x70\x70\xe2\x31\x34\x0b\xd0\xe2\x71\xc8\x8b\x8f\xee\xcd"
"\xa1\x00\x91\x84\x18\x04\xd0\x9e\x21\xd9\x5c\xcd\xf9\x4e\x75"
"\x32\x81\x1d\xf3\xe7\x41\xfc\x22\xcd\x3b\x88\x09\xae\xb5\xc5"
"\x5f\x5c\x25\x65\x71\xfb\x61\xd0\x8c\xc8\x53\xee\xee\x83\xdf"
"\x41\xf8\x96\xda\x5f\x06\x21\x87\xf8\xe4\x07\xe7\xf5\xdb\xc0"
"\x3e\x9b";

static EVP_PKEY *dummy_rsa_ossl_load_privkey(ENGINE *eng, const char *key_id,
					     UI_METHOD *ui_method,
					     void *callback_data)
{
	EVP_PKEY *pkey = NULL;
	RSA *rsa = NULL;

	if (strncmp(key_id, "dev", 3))
		return NULL;

	pkey = EVP_PKEY_new();
	if (!pkey)
		goto pkey_err;

	rsa = RSA_new();
	if (!rsa)
		goto err;

	if (!EVP_PKEY_assign_RSA(pkey, rsa))
		goto err;

	if (!RSA_set0_key(rsa,
			  BN_bin2bn(n, sizeof(n) - 1, NULL),
			  BN_bin2bn(e, sizeof(e) - 1, NULL),
			  BN_bin2bn(d, sizeof(d) - 1, NULL)))
		goto err;

	return pkey;

pkey_err:
	EVP_PKEY_free(pkey);
err:
	RSA_free(rsa);
	return NULL;
}

static int bind_helper(ENGINE *e, const char *id)
{
	const RSA_METHOD *rsa_default_meth = RSA_get_default_method();
	RSA_METHOD *dummy_rsa_meth;

	if (id && strcmp(id, engine_dummy_rsa_id))
		return 0;

	dummy_rsa_meth = RSA_meth_dup(rsa_default_meth);

	ENGINE_set_load_privkey_function(e, dummy_rsa_ossl_load_privkey);

	return ENGINE_set_id(e, engine_dummy_rsa_id) &&
		ENGINE_set_name(e, engine_dummy_rsa_name) &&
		ENGINE_set_RSA(e, dummy_rsa_meth);
}

IMPLEMENT_DYNAMIC_CHECK_FN()
IMPLEMENT_DYNAMIC_BIND_FN(bind_helper)
